/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import io.testomat.junit.methodexporter.filefinder.FileFinder;
import io.testomat.junit.methodexporter.parser.FileParser;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCodeParameterNameResolver {
    private static final Logger logger = LoggerFactory.getLogger(SourceCodeParameterNameResolver.class);
    private static final SourceCodeParameterNameResolver INSTANCE = new SourceCodeParameterNameResolver();
    private final Map<String, List<String>> parameterNameCache = new ConcurrentHashMap<String, List<String>>();
    private final FileFinder fileFinder;
    private final FileParser fileParser;

    SourceCodeParameterNameResolver(FileFinder fileFinder, FileParser fileParser) {
        this.fileFinder = fileFinder;
        this.fileParser = fileParser;
    }

    SourceCodeParameterNameResolver() {
        this.fileFinder = new FileFinder();
        this.fileParser = new FileParser();
    }

    public static SourceCodeParameterNameResolver getInstance() {
        return INSTANCE;
    }

    public List<String> resolveParameterNames(Method method) {
        if (method == null) {
            return new ArrayList<String>();
        }
        String cacheKey = this.createCacheKey(method);
        List<String> cachedNames = this.parameterNameCache.get(cacheKey);
        if (cachedNames != null) {
            logger.trace("Retrieved parameter names from cache for method: {}", (Object)cacheKey);
            return new ArrayList<String>(cachedNames);
        }
        List<String> sourceNames = this.parseParameterNamesFromSource(method);
        if (sourceNames != null && !sourceNames.isEmpty()) {
            logger.debug("Successfully parsed param names from source for method: {}", (Object)cacheKey);
            this.parameterNameCache.put(cacheKey, sourceNames);
            return new ArrayList<String>(sourceNames);
        }
        List<String> reflectionNames = this.getReflectionBasedNames(method);
        logger.debug("Using reflection-based parameter names for method: {}", (Object)cacheKey);
        this.parameterNameCache.put(cacheKey, reflectionNames);
        return new ArrayList<String>(reflectionNames);
    }

    public String getParameterName(Method method, int parameterIndex) {
        List<String> names = this.resolveParameterNames(method);
        if (parameterIndex >= 0 && parameterIndex < names.size()) {
            return names.get(parameterIndex);
        }
        logger.warn("Parameter index {} out of bounds for method {}, using generic fallback", (Object)parameterIndex, (Object)(method != null ? method.getName() : "null"));
        return "param" + parameterIndex;
    }

    private List<String> parseParameterNamesFromSource(Method method) {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            String sourceFilePath = this.fileFinder.getTestClassFilePath(declaringClass);
            if (sourceFilePath == null) {
                logger.debug("Could not find source file for class: {}", (Object)declaringClass.getName());
                return null;
            }
            CompilationUnit compilationUnit = this.fileParser.parseFile(sourceFilePath);
            if (compilationUnit == null) {
                logger.debug("Could not parse source file: {}", (Object)sourceFilePath);
                return null;
            }
            MethodDeclaration methodDeclaration = this.findMethodInCompilationUnit(compilationUnit, declaringClass, method);
            if (methodDeclaration == null) {
                logger.debug("Could not find method {} in source file: {}", (Object)method.getName(), (Object)sourceFilePath);
                return null;
            }
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (Parameter param : methodDeclaration.getParameters()) {
                parameterNames.add(param.getNameAsString());
            }
            logger.trace("Parsed {} parameter names from source for method: {}", (Object)parameterNames.size(), (Object)method.getName());
            return parameterNames;
        }
        catch (Exception e) {
            logger.debug("Failed to parse parameter names from source for method: {} - {}", (Object)method.getName(), (Object)e.getMessage());
            return null;
        }
    }

    private MethodDeclaration findMethodInCompilationUnit(CompilationUnit compilationUnit, Class<?> declaringClass, Method targetMethod) {
        String className = this.getSimpleClassName(declaringClass);
        return compilationUnit.findAll(ClassOrInterfaceDeclaration.class).stream().filter(classDecl -> className.equals(classDecl.getNameAsString()) || declaringClass.getSimpleName().equals(classDecl.getNameAsString())).flatMap(classDecl -> classDecl.getMethods().stream()).filter(methodDecl -> targetMethod.getName().equals(methodDecl.getNameAsString())).filter(methodDecl -> this.parametersMatch((MethodDeclaration)methodDecl, targetMethod)).findFirst().orElse(null);
    }

    private boolean parametersMatch(MethodDeclaration methodDecl, Method reflectionMethod) {
        if (methodDecl.getParameters().size() != reflectionMethod.getParameterCount()) {
            return false;
        }
        Class<?>[] reflectionParamTypes = reflectionMethod.getParameterTypes();
        for (int i = 0; i < methodDecl.getParameters().size(); ++i) {
            String reflectionTypeName;
            Parameter astParam = (Parameter)methodDecl.getParameters().get(i);
            Class<?> reflectionParamType = reflectionParamTypes[i];
            String astTypeName = astParam.getTypeAsString();
            if (this.typesMatch(astTypeName, reflectionTypeName = this.getSimpleTypeName(reflectionParamType))) continue;
            return false;
        }
        return true;
    }

    private boolean typesMatch(String astTypeName, String reflectionTypeName) {
        if (astTypeName.equals(reflectionTypeName)) {
            return true;
        }
        String astSimple = this.getLastComponent(astTypeName);
        String reflectionSimple = this.getLastComponent(reflectionTypeName);
        return astSimple.equals(reflectionSimple);
    }

    private List<String> getReflectionBasedNames(Method method) {
        java.lang.reflect.Parameter[] parameters;
        ArrayList<String> names = new ArrayList<String>();
        for (java.lang.reflect.Parameter param : parameters = method.getParameters()) {
            names.add(param.getName());
        }
        return names;
    }

    private String createCacheKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(paramTypes[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    private String getSimpleClassName(Class<?> clazz) {
        String fullName = clazz.getName();
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot >= 0) {
            return fullName.substring(lastDot + 1);
        }
        return fullName;
    }

    private String getSimpleTypeName(Class<?> type) {
        if (type.isArray()) {
            return this.getSimpleTypeName(type.getComponentType()) + "[]";
        }
        return type.getSimpleName();
    }

    private String getLastComponent(String str) {
        int lastDot = str.lastIndexOf(46);
        if (lastDot >= 0) {
            return str.substring(lastDot + 1);
        }
        return str;
    }

    public void clearCache() {
        this.parameterNameCache.clear();
        logger.debug("Parameter name cache cleared");
    }

    public int getCacheSize() {
        return this.parameterNameCache.size();
    }
}

