/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers;

import io.testomat.junit.exception.ParameterExtractionException;
import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.ParameterExtractionHandler;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterExtractionHandler
implements ParameterExtractionHandler {
    private static final Pattern DISPLAY_NAME_PATTERN = Pattern.compile("^\\[\\d+\\]\\s*(.*)$");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final Object extractParameters(ParameterExtractionContext context) {
        if (!context.isValid()) {
            return null;
        }
        try {
            ParseResult parseResult = this.extractFromDisplayNameWithResult(context);
            if (parseResult.isSuccessful()) {
                return this.formatParameters(parseResult.getValue(), context);
            }
            Object annotationValue = this.extractFromAnnotation(context);
            return this.formatParameters(annotationValue, context);
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract {} parameters for: {}", new Object[]{this.getStrategyName(), context.getDisplayName(), e});
            throw new ParameterExtractionException("Failed to extract " + this.getStrategyName() + " parameters", e);
        }
    }

    protected ParseResult extractFromDisplayNameWithResult(ParameterExtractionContext context) {
        String displayName = context.getDisplayName();
        if (displayName == null || displayName.trim().isEmpty()) {
            return ParseResult.failure();
        }
        Matcher matcher = DISPLAY_NAME_PATTERN.matcher(displayName.trim());
        if (matcher.matches()) {
            String valueStr = matcher.group(1).trim();
            try {
                Object parsedValue = this.parseDisplayNameValue(valueStr, context);
                return ParseResult.success(parsedValue);
            }
            catch (Exception e) {
                return ParseResult.failure();
            }
        }
        return ParseResult.failure();
    }

    protected Object formatParameters(Object value, ParameterExtractionContext context) {
        Method method = context.getTestMethod();
        if (method == null) {
            return this.createGenericParameterMap(value);
        }
        if (value instanceof Object[]) {
            return this.createMultiParameterMap((Object[])value, context);
        }
        return this.createSingleParameterMap(value, context);
    }

    protected Map<String, Object> createMultiParameterMap(Object[] values, ParameterExtractionContext context) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < values.length; ++i) {
            String parameterName = context.getParameterName(i);
            parameterMap.put(parameterName, values[i]);
        }
        return parameterMap;
    }

    protected Map<String, Object> createSingleParameterMap(Object value, ParameterExtractionContext context) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        String parameterName = context.getParameterName(0);
        parameterMap.put(parameterName, value);
        return parameterMap;
    }

    protected Map<String, Object> createGenericParameterMap(Object value) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                parameterMap.put("param" + i, values[i]);
            }
        } else {
            parameterMap.put("param0", value);
        }
        return parameterMap;
    }

    protected Object parseTypedValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String trimmed = value.trim();
        if ("null".equals(trimmed)) {
            return null;
        }
        if ("true".equalsIgnoreCase(trimmed)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmed)) {
            return false;
        }
        try {
            if (trimmed.contains(".")) {
                return Double.parseDouble(trimmed);
            }
            long longVal = Long.parseLong(trimmed);
            if (longVal >= Integer.MIN_VALUE && longVal <= Integer.MAX_VALUE) {
                return (int)longVal;
            }
            return longVal;
        }
        catch (NumberFormatException e) {
            this.logger.warn("Failed to parse {} as a number", (Object)trimmed);
            return value;
        }
    }

    protected String removeQuotes(String value) {
        if (value == null || value.length() < 2) {
            return value;
        }
        String trimmed = value.trim();
        if (trimmed.startsWith("\"") && trimmed.endsWith("\"") || trimmed.startsWith("'") && trimmed.endsWith("'")) {
            return trimmed.substring(1, trimmed.length() - 1);
        }
        return value;
    }

    protected abstract Object parseDisplayNameValue(String var1, ParameterExtractionContext var2);

    protected abstract Object extractFromAnnotation(ParameterExtractionContext var1);

    protected static class ParseResult {
        private final boolean successful;
        private final Object value;

        private ParseResult(boolean successful, Object value) {
            this.successful = successful;
            this.value = value;
        }

        public static ParseResult success(Object value) {
            return new ParseResult(true, value);
        }

        public static ParseResult failure() {
            return new ParseResult(false, null);
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

