/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.AbstractParameterExtractionHandler;
import java.lang.reflect.Constructor;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class ArgumentsSourceHandler
extends AbstractParameterExtractionHandler {
    @Override
    public String getStrategyName() {
        return "ArgumentsSourceExtractionStrategy";
    }

    @Override
    protected Object parseDisplayNameValue(String valueStr, ParameterExtractionContext context) {
        return this.parseArgumentsSourceDisplayName(valueStr, context);
    }

    @Override
    protected Object extractFromAnnotation(ParameterExtractionContext context) {
        ArgumentsSource argumentsSource = context.getAnnotation(ArgumentsSource.class);
        if (argumentsSource == null) {
            return new Object[0];
        }
        return this.extractFromArgumentsProvider(argumentsSource, context);
    }

    private Object[] extractFromArgumentsProvider(ArgumentsSource argumentsSource, ParameterExtractionContext context) {
        try {
            Class providerClass = argumentsSource.value();
            if (providerClass == null) {
                return new Object[0];
            }
            ArgumentsProvider provider = this.instantiateProvider(providerClass);
            if (provider == null) {
                return new Object[0];
            }
            ExtensionContext extensionContext = context.getExtensionContext();
            if (extensionContext == null) {
                return new Object[0];
            }
            Stream argumentsStream = provider.provideArguments(extensionContext);
            if (argumentsStream == null) {
                return new Object[0];
            }
            Arguments firstArguments = argumentsStream.findFirst().orElse(null);
            if (firstArguments != null) {
                return firstArguments.get();
            }
            return new Object[0];
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract parameters from ArgumentsProvider", (Throwable)e);
            return new Object[0];
        }
    }

    private ArgumentsProvider instantiateProvider(Class<? extends ArgumentsProvider> clazz) {
        try {
            Constructor<? extends ArgumentsProvider> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.debug("Failed to instantiate ArgumentsProvider with default constructor: {}", (Object)clazz.getName(), (Object)e);
            try {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                    if (constructor.getParameterCount() != 0) continue;
                    constructor.setAccessible(true);
                    return (ArgumentsProvider)constructor.newInstance(new Object[0]);
                }
                if (constructors.length > 0) {
                    Constructor<?> firstConstructor = constructors[0];
                    firstConstructor.setAccessible(true);
                    Object[] nullArgs = new Object[firstConstructor.getParameterCount()];
                    return (ArgumentsProvider)firstConstructor.newInstance(nullArgs);
                }
            }
            catch (Exception fallbackException) {
                this.logger.debug("Failed to instantiate ArgumentsProvider with fallback approaches: {}", (Object)clazz.getName(), (Object)fallbackException);
            }
            return null;
        }
    }

    private Object[] parseArgumentsSourceDisplayName(String displayValue, ParameterExtractionContext context) {
        if (displayValue == null || displayValue.trim().isEmpty()) {
            return new Object[0];
        }
        String trimmed = displayValue.trim();
        if (trimmed.startsWith("Arguments{arguments=[") && trimmed.endsWith("]}")) {
            String argsContent = trimmed.substring(21, trimmed.length() - 2);
            return this.parseCommaSeparatedValues(argsContent);
        }
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            String arrayContent = trimmed.substring(1, trimmed.length() - 1);
            return this.parseCommaSeparatedValues(arrayContent);
        }
        if (trimmed.contains("(") && trimmed.contains(")")) {
            int startParen = trimmed.indexOf(40);
            int endParen = trimmed.lastIndexOf(41);
            if (startParen >= 0 && endParen > startParen) {
                String argsContent = trimmed.substring(startParen + 1, endParen);
                return this.parseCommaSeparatedValues(argsContent);
            }
        }
        if (trimmed.contains(",")) {
            return this.parseCommaSeparatedValues(trimmed);
        }
        return new Object[]{this.parseTypedValue(trimmed)};
    }

    private Object[] parseCommaSeparatedValues(String content) {
        if (content == null || content.trim().isEmpty()) {
            return new Object[0];
        }
        String[] parts = content.split(",");
        Object[] result = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            result[i] = this.parseTypedValue(part);
        }
        return result;
    }

    @Override
    protected Object parseTypedValue(String value) {
        String trimmed = this.removeQuotes(value);
        return super.parseTypedValue(trimmed);
    }
}

