/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.AbstractParameterExtractionHandler;
import io.testomat.junit.extractor.strategy.handlers.util.CsvParsingUtils;
import org.junit.jupiter.params.provider.CsvSource;

public class CsvSourceHandler
extends AbstractParameterExtractionHandler {
    @Override
    public String getStrategyName() {
        return "CsvSourceExtractionStrategy";
    }

    @Override
    protected Object parseDisplayNameValue(String valueStr, ParameterExtractionContext context) {
        CsvSource csvSource = context.getAnnotation(CsvSource.class);
        if (csvSource == null) {
            return CsvParsingUtils.parseCommaSeparatedValues(valueStr);
        }
        return this.parseCsvString(valueStr, csvSource);
    }

    @Override
    protected Object extractFromAnnotation(ParameterExtractionContext context) {
        CsvSource csvSource = context.getAnnotation(CsvSource.class);
        if (csvSource == null) {
            return new Object[0];
        }
        try {
            String[] csvLines = csvSource.value();
            if (csvLines == null || csvLines.length == 0) {
                return new Object[0];
            }
            String firstLine = csvLines[0];
            return this.parseCsvString(firstLine, csvSource);
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract CSV from annotation", (Throwable)e);
            return new Object[0];
        }
    }

    private Object[] parseCsvString(String csvString, CsvSource csvSource) {
        if (csvString == null || csvString.trim().isEmpty()) {
            return new Object[0];
        }
        try {
            char delimiterChar = csvSource.delimiter();
            String delimiter = String.valueOf(delimiterChar);
            String[] nullValuesArray = new String[]{};
            char quoteCharacter = '\"';
            if (delimiterChar == '\u0000' || delimiter.equals("\u0000")) {
                delimiter = ",";
            }
            return CsvParsingUtils.parseCsvString(csvString, delimiter, quoteCharacter, nullValuesArray);
        }
        catch (Exception e) {
            this.logger.debug("Failed to parse CSV string: {}", (Object)csvString, (Object)e);
            return csvString.split(",");
        }
    }
}

