/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.AbstractParameterExtractionHandler;
import io.testomat.junit.util.ParameterizedTestSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class EnumSourceHandler
extends AbstractParameterExtractionHandler {
    @Override
    public String getStrategyName() {
        return "EnumSourceExtractionStrategy";
    }

    @Override
    protected Object parseDisplayNameValue(String valueStr, ParameterExtractionContext context) {
        return this.parseEnumValue(valueStr, context);
    }

    @Override
    protected Object extractFromAnnotation(ParameterExtractionContext context) {
        if (!ParameterizedTestSupport.isAvailable()) {
            return null;
        }
        return ParameterizedTestSupport.loadAnnotationClass("EnumSource").map(enumSourceClass -> {
            Object enumSource = context.getAnnotation(enumSourceClass);
            if (enumSource == null) {
                return null;
            }
            return this.extractValueFromEnumSource((Annotation)enumSource, context);
        }).orElse(null);
    }

    private Object extractValueFromEnumSource(Annotation enumSource, ParameterExtractionContext context) {
        try {
            Class<? extends Annotation> annotationClass = enumSource.annotationType();
            Method valueMethod = annotationClass.getMethod("value", new Class[0]);
            Class<Enum<?>> enumClass = (Class<Enum<?>>)valueMethod.invoke((Object)enumSource, new Object[0]);
            if (this.isNullEnum(enumClass)) {
                enumClass = this.inferEnumClassFromMethod(context);
            }
            if (enumClass == null) {
                return null;
            }
            Enum<?>[] enumConstants = enumClass.getEnumConstants();
            if (enumConstants == null || enumConstants.length == 0) {
                return null;
            }
            Method namesMethod = annotationClass.getMethod("names", new Class[0]);
            String[] names = (String[])namesMethod.invoke((Object)enumSource, new Object[0]);
            if (names.length > 0) {
                return this.findFirstValidEnumConstant(enumClass, names);
            }
            return enumConstants[0];
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract enum from annotation", (Throwable)e);
            return null;
        }
    }

    private boolean isNullEnum(Class<? extends Enum<?>> enumClass) {
        return enumClass.getName().equals("org.junit.jupiter.params.provider.NullEnum");
    }

    private Object findFirstValidEnumConstant(Class<? extends Enum<?>> enumClass, String[] names) {
        for (String name : names) {
            try {
                return Enum.valueOf(enumClass, name);
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Could not find enum constant {}", (Object)name);
            }
        }
        return null;
    }

    private Class<? extends Enum<?>> inferEnumClassFromMethod(ParameterExtractionContext context) {
        Method method = context.getTestMethod();
        if (method == null) {
            return null;
        }
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return null;
        }
        Class<?> paramType = parameters[0].getType();
        if (paramType.isEnum()) {
            return paramType;
        }
        return null;
    }

    private Object parseEnumValue(String value, ParameterExtractionContext context) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String trimmed = value.trim();
        if ("null".equals(trimmed)) {
            return null;
        }
        if (!ParameterizedTestSupport.isAvailable()) {
            return value;
        }
        try {
            return ParameterizedTestSupport.loadAnnotationClass("EnumSource").map(enumSourceClass -> {
                Object enumSource = context.getAnnotation(enumSourceClass);
                if (enumSource == null) {
                    return value;
                }
                return this.parseEnumWithReflection((Annotation)enumSource, trimmed, context);
            }).orElse(value);
        }
        catch (Exception e) {
            this.logger.debug("Failed to parse enum value: {}", (Object)trimmed, (Object)e);
            return value;
        }
    }

    private Object parseEnumWithReflection(Annotation enumSource, String trimmed, ParameterExtractionContext context) {
        try {
            Method valueMethod = enumSource.annotationType().getMethod("value", new Class[0]);
            Class<? extends Enum<?>> enumClass = (Class<? extends Enum<?>>)valueMethod.invoke((Object)enumSource, new Object[0]);
            if (this.isNullEnum(enumClass)) {
                enumClass = this.inferEnumClassFromMethod(context);
            }
            if (enumClass != null) {
                String enumName = this.extractEnumName(trimmed);
                return Enum.valueOf(enumClass, enumName);
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to parse enum value with reflection: {}", (Object)trimmed, (Object)e);
        }
        return trimmed;
    }

    private String extractEnumName(String trimmed) {
        if (trimmed.contains(".")) {
            return trimmed.substring(trimmed.lastIndexOf(46) + 1);
        }
        return trimmed;
    }
}

