/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.AbstractParameterExtractionHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MethodSourceHandler
extends AbstractParameterExtractionHandler {
    @Override
    public String getStrategyName() {
        return "MethodSourceExtractionStrategy";
    }

    @Override
    protected Object parseDisplayNameValue(String valueStr, ParameterExtractionContext context) {
        return this.parseMethodSourceDisplayName(valueStr, context);
    }

    @Override
    protected Object extractFromAnnotation(ParameterExtractionContext context) {
        MethodSource methodSource = context.getAnnotation(MethodSource.class);
        if (methodSource == null) {
            return new Object[0];
        }
        return this.extractFromMethodSource(methodSource, context);
    }

    private Object[] extractFromMethodSource(MethodSource methodSource, ParameterExtractionContext context) {
        try {
            Method testMethod;
            String[] methodNames = methodSource.value();
            if (methodNames.length == 0 && (testMethod = context.getTestMethod()) != null) {
                methodNames = new String[]{this.inferMethodName(testMethod.getName())};
            }
            if (methodNames.length == 0) {
                return new Object[0];
            }
            String methodName = methodNames[0];
            Method sourceMethod = this.resolveSourceMethod(methodName, context);
            if (sourceMethod != null) {
                Object result = this.invokeSourceMethod(sourceMethod);
                return this.extractArgumentsFromResult(result);
            }
            return new Object[0];
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract parameters from method source", (Throwable)e);
            return new Object[0];
        }
    }

    private String inferMethodName(String testMethodName) {
        if (testMethodName.startsWith("test")) {
            String baseName = testMethodName.substring(4);
            return "provide" + baseName;
        }
        return testMethodName + "Provider";
    }

    private Method resolveSourceMethod(String methodName, ParameterExtractionContext context) {
        try {
            Method testMethod = context.getTestMethod();
            if (testMethod == null) {
                return null;
            }
            Class<?> testClass = testMethod.getDeclaringClass();
            if (methodName.contains("#")) {
                String[] parts = methodName.split("#", 2);
                String className = parts[0];
                String simpleMethodName = parts[1];
                try {
                    Class<?> sourceClass = Class.forName(className);
                    return this.findMethodByName(sourceClass, simpleMethodName);
                }
                catch (ClassNotFoundException e) {
                    this.logger.debug("Could not find class: {}", (Object)className, (Object)e);
                    return null;
                }
            }
            return this.findMethodByName(testClass, methodName);
        }
        catch (Exception e) {
            this.logger.debug("Failed to resolve source method: {}", (Object)methodName, (Object)e);
            return null;
        }
    }

    private Method findMethodByName(Class<?> clazz, String methodName) {
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?> returnType;
            if (!method.getName().equals(methodName) || !Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || !Stream.class.isAssignableFrom(returnType = method.getReturnType()) && !Iterator.class.isAssignableFrom(returnType) && !returnType.isArray()) continue;
            return method;
        }
        return null;
    }

    private Object invokeSourceMethod(Method sourceMethod) {
        try {
            sourceMethod.setAccessible(true);
            return sourceMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.logger.debug("Failed to invoke source method: {}", (Object)sourceMethod.getName(), (Object)e);
            return null;
        }
    }

    private Object[] extractArgumentsFromResult(Object result) {
        if (result == null) {
            return new Object[0];
        }
        try {
            Object[] array;
            if (result instanceof Stream) {
                Stream stream = (Stream)result;
                Object firstElement = stream.findFirst().orElse(null);
                return this.convertToArgumentArray(firstElement);
            }
            if (result instanceof Iterator) {
                Iterator iterator = (Iterator)result;
                if (iterator.hasNext()) {
                    Object firstElement = iterator.next();
                    return this.convertToArgumentArray(firstElement);
                }
            } else if (result.getClass().isArray() && (array = (Object[])result).length > 0) {
                return this.convertToArgumentArray(array[0]);
            }
            return new Object[]{result};
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract arguments from result", (Throwable)e);
            return new Object[0];
        }
    }

    private Object[] convertToArgumentArray(Object element) {
        if (element == null) {
            return new Object[]{null};
        }
        if (element instanceof Arguments) {
            Arguments args = (Arguments)element;
            return args.get();
        }
        if (element instanceof Object[]) {
            return (Object[])element;
        }
        return new Object[]{element};
    }

    private Object[] parseMethodSourceDisplayName(String displayValue, ParameterExtractionContext context) {
        if (displayValue == null || displayValue.trim().isEmpty()) {
            return new Object[0];
        }
        String trimmed = displayValue.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            String arrayContent = trimmed.substring(1, trimmed.length() - 1);
            return this.parseCommaSeparatedValues(arrayContent);
        }
        if (trimmed.startsWith("Arguments{arguments=[") && trimmed.endsWith("]}")) {
            String argsContent = trimmed.substring(21, trimmed.length() - 2);
            return this.parseCommaSeparatedValues(argsContent);
        }
        if (trimmed.contains(",")) {
            return this.parseCommaSeparatedValues(trimmed);
        }
        return new Object[]{this.parseTypedValue(trimmed)};
    }

    private Object[] parseCommaSeparatedValues(String content) {
        if (content == null || content.trim().isEmpty()) {
            return new Object[0];
        }
        String[] parts = content.split(",");
        Object[] result = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            result[i] = this.parseTypedValue(part);
        }
        return result;
    }
}

