/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.AbstractParameterExtractionHandler;
import io.testomat.junit.util.ParameterizedTestSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class ValueSourceHandler
extends AbstractParameterExtractionHandler {
    @Override
    public String getStrategyName() {
        return "ValueSourceExtractionStrategy";
    }

    @Override
    protected Object parseDisplayNameValue(String valueStr, ParameterExtractionContext context) {
        return this.parseValue(valueStr);
    }

    @Override
    protected Object extractFromAnnotation(ParameterExtractionContext context) {
        if (!ParameterizedTestSupport.isAvailable()) {
            return null;
        }
        return ParameterizedTestSupport.loadAnnotationClass("ValueSource").map(valueSourceClass -> {
            Object valueSource = context.getAnnotation(valueSourceClass);
            if (valueSource == null) {
                return null;
            }
            return this.extractValueFromValueSource((Annotation)valueSource);
        }).orElse(null);
    }

    private Object extractValueFromValueSource(Annotation valueSource) {
        try {
            String[] methodNames;
            Class<? extends Annotation> annotationClass = valueSource.annotationType();
            for (String methodName : methodNames = new String[]{"strings", "ints", "longs", "doubles", "floats", "bytes", "shorts", "booleans", "chars", "classes"}) {
                Object result = this.tryExtractArray(valueSource, annotationClass, methodName);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object tryExtractArray(Annotation annotation, Class<?> annotationClass, String methodName) {
        try {
            int length;
            Method method = annotationClass.getMethod(methodName, new Class[0]);
            Object array = method.invoke((Object)annotation, new Object[0]);
            if (array != null && (length = Array.getLength(array)) > 0) {
                return Array.get(array, 0);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object parseValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String trimmed = value.trim();
        if (trimmed.length() == 1) {
            return Character.valueOf(trimmed.charAt(0));
        }
        return this.parseTypedValue(value);
    }
}

