/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.listener;

import io.testomat.core.propertyconfig.impl.PropertyProviderFactoryImpl;
import io.testomat.core.propertyconfig.interf.PropertyProvider;
import io.testomat.core.runmanager.GlobalRunManager;
import io.testomat.junit.methodexporter.MethodExportManager;
import io.testomat.junit.reporter.JunitTestReporter;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JunitListener
implements BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback,
TestWatcher {
    private static final Logger log = LoggerFactory.getLogger(JunitListener.class);
    private final MethodExportManager methodExportManager;
    private final GlobalRunManager runManager;
    private final JunitTestReporter reporter;
    private final PropertyProvider provider;
    private final Set<String> processedClasses;

    public JunitListener() {
        this.methodExportManager = new MethodExportManager();
        this.runManager = GlobalRunManager.getInstance();
        this.reporter = new JunitTestReporter();
        this.processedClasses = ConcurrentHashMap.newKeySet();
        this.provider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
    }

    public JunitListener(MethodExportManager methodExportManager, GlobalRunManager runManager, JunitTestReporter reporter, PropertyProvider provider) {
        this.methodExportManager = methodExportManager;
        this.runManager = runManager;
        this.reporter = reporter;
        this.provider = provider;
        this.processedClasses = ConcurrentHashMap.newKeySet();
    }

    public void beforeAll(ExtensionContext context) {
        if (!this.isListeningRequired()) {
            return;
        }
        this.runManager.incrementSuiteCounter();
    }

    public void afterAll(ExtensionContext context) {
        if (!this.isListeningRequired()) {
            return;
        }
        this.exportTestClassIfNotProcessed(context);
        this.runManager.decrementSuiteCounter();
    }

    public void beforeEach(ExtensionContext extensionContext) {
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        if (!this.isListeningRequired()) {
            return;
        }
        this.reporter.reportTestResult(context, "skipped", reason.orElse("Test disabled"));
        this.exportTestClassIfNotProcessed(context);
    }

    public void testSuccessful(ExtensionContext context) {
        if (!this.isListeningRequired()) {
            return;
        }
        this.reporter.reportTestResult(context, "passed", null);
        this.exportTestClassIfNotProcessed(context);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        if (!this.isListeningRequired()) {
            return;
        }
        this.reporter.reportTestResult(context, "skipped", cause.getMessage());
        this.exportTestClassIfNotProcessed(context);
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        if (!this.isListeningRequired()) {
            return;
        }
        this.reporter.reportTestResult(context, "failed", cause.getMessage());
        this.exportTestClassIfNotProcessed(context);
    }

    private void exportTestClassIfNotProcessed(ExtensionContext context) {
        if (!this.isListeningRequired()) {
            return;
        }
        Optional testClass = context.getTestClass();
        if (testClass.isEmpty()) {
            return;
        }
        Class clazz = (Class)testClass.get();
        String className = clazz.getName();
        if (this.processedClasses.add(className)) {
            this.methodExportManager.loadTestBodyForClass(clazz);
        }
    }

    private boolean isListeningRequired() {
        try {
            return this.provider.getProperty("testomatio") != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

