/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.methodexporter.sender;

import io.testomat.core.client.http.NativeHttpClient;
import io.testomat.core.propertyconfig.impl.PropertyProviderFactoryImpl;
import io.testomat.core.propertyconfig.interf.PropertyProvider;
import io.testomat.junit.exception.MethodExporterException;
import io.testomat.junit.methodexporter.ExporterRequestBodyBuilder;
import io.testomat.junit.model.ExporterTestCase;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportSender {
    private static final Logger log = LoggerFactory.getLogger(ExportSender.class);
    private static final String LOAD_URL_PART = "api/load?api_key=";
    private static final int RETRY_TIMEOUT_MILLISECONDS = 1500;
    private static final int RETRY_MAX_ATTEMPTS = 2;
    private final PropertyProvider provider;
    private String apiUrl;

    public ExportSender() {
        this.provider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
        this.apiUrl = this.provider.getProperty("testomatio.url");
    }

    public ExportSender(PropertyProvider provider) {
        this.provider = provider;
    }

    public void sendTestCases(List<ExporterTestCase> exporterTestCases) {
        if (exporterTestCases.isEmpty()) {
            log.debug("No exporter test cases found");
            return;
        }
        ExporterRequestBodyBuilder exporterRequestBodyBuilder = new ExporterRequestBodyBuilder();
        NativeHttpClient client = new NativeHttpClient();
        String requestBody = exporterRequestBodyBuilder.buildRequestBody(exporterTestCases);
        String url = this.apiUrl + LOAD_URL_PART + this.provider.getProperty("testomatio");
        log.info("Sending test case export to API: {} test cases", (Object)exporterTestCases.size());
        log.info("Export request body: {}", (Object)requestBody);
        for (int attempt = 1; attempt <= 2; ++attempt) {
            log.debug("Attempt {} of {}", (Object)attempt, (Object)exporterTestCases.size());
            try {
                if (attempt > 1) {
                    Thread.sleep(1500L);
                }
                client.post(url, requestBody, null);
                return;
            }
            catch (Exception e) {
                boolean isLastAttempt;
                boolean is422Error = e.getMessage().contains("422");
                boolean bl = isLastAttempt = attempt == 2;
                if (is422Error && !isLastAttempt) continue;
                throw new MethodExporterException("Failed to export test cases", e);
            }
        }
    }
}

