/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ParameterizedTestSupport {
    private static final boolean PARAMETERIZED_TEST_AVAILABLE = ParameterizedTestSupport.isParameterizedTestAvailable();
    private static final Map<String, Class<?>> CLASS_CACHE = new HashMap();
    private static final Map<String, String> ANNOTATION_CLASS_NAMES = new HashMap<String, String>();

    private ParameterizedTestSupport() {
    }

    public static boolean isAvailable() {
        return PARAMETERIZED_TEST_AVAILABLE;
    }

    public static Optional<Class<?>> loadClass(String simpleName) {
        if (!PARAMETERIZED_TEST_AVAILABLE) {
            return Optional.empty();
        }
        String className = ANNOTATION_CLASS_NAMES.get(simpleName);
        if (className == null) {
            return Optional.empty();
        }
        return ParameterizedTestSupport.loadClassByName(className);
    }

    public static Optional<Class<? extends Annotation>> loadAnnotationClass(String simpleName) {
        Optional<Class<?>> clazz = ParameterizedTestSupport.loadClass(simpleName);
        if (clazz.isPresent() && clazz.get().isAnnotation()) {
            return Optional.of(clazz.get());
        }
        return Optional.empty();
    }

    public static Optional<Class<?>> loadClassByName(String className) {
        if (!PARAMETERIZED_TEST_AVAILABLE) {
            return Optional.empty();
        }
        if (CLASS_CACHE.containsKey(className)) {
            return Optional.ofNullable(CLASS_CACHE.get(className));
        }
        try {
            Class<?> clazz = Class.forName(className);
            CLASS_CACHE.put(className, clazz);
            return Optional.of(clazz);
        }
        catch (ClassNotFoundException e) {
            CLASS_CACHE.put(className, null);
            return Optional.empty();
        }
    }

    public static boolean isJunitParamsAnnotation(Annotation annotation) {
        if (!PARAMETERIZED_TEST_AVAILABLE || annotation == null) {
            return false;
        }
        String packageName = annotation.annotationType().getPackage().getName();
        return packageName.startsWith("org.junit.jupiter.params");
    }

    public static boolean isParameterizedTest(Method method) {
        if (!PARAMETERIZED_TEST_AVAILABLE || method == null) {
            return false;
        }
        Optional<Class<? extends Annotation>> parameterizedTestClass = ParameterizedTestSupport.loadAnnotationClass("ParameterizedTest");
        return parameterizedTestClass.isPresent() && method.isAnnotationPresent(parameterizedTestClass.get());
    }

    private static boolean isParameterizedTestAvailable() {
        try {
            Class.forName("org.junit.jupiter.params.ParameterizedTest");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        ANNOTATION_CLASS_NAMES.put("ParameterizedTest", "org.junit.jupiter.params.ParameterizedTest");
        ANNOTATION_CLASS_NAMES.put("ValueSource", "org.junit.jupiter.params.provider.ValueSource");
        ANNOTATION_CLASS_NAMES.put("EnumSource", "org.junit.jupiter.params.provider.EnumSource");
        ANNOTATION_CLASS_NAMES.put("CsvSource", "org.junit.jupiter.params.provider.CsvSource");
        ANNOTATION_CLASS_NAMES.put("CsvFileSource", "org.junit.jupiter.params.provider.CsvFileSource");
        ANNOTATION_CLASS_NAMES.put("MethodSource", "org.junit.jupiter.params.provider.MethodSource");
        ANNOTATION_CLASS_NAMES.put("ArgumentsSource", "org.junit.jupiter.params.provider.ArgumentsSource");
        ANNOTATION_CLASS_NAMES.put("NullSource", "org.junit.jupiter.params.provider.NullSource");
        ANNOTATION_CLASS_NAMES.put("EmptySource", "org.junit.jupiter.params.provider.EmptySource");
        ANNOTATION_CLASS_NAMES.put("NullAndEmptySource", "org.junit.jupiter.params.provider.NullAndEmptySource");
        ANNOTATION_CLASS_NAMES.put("Arguments", "org.junit.jupiter.params.provider.Arguments");
        ANNOTATION_CLASS_NAMES.put("ArgumentsProvider", "org.junit.jupiter.params.provider.ArgumentsProvider");
    }
}

