/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client;

import com.testomatio.reporter.client.ApiInterface;
import com.testomatio.reporter.client.http.HttpClient;
import com.testomatio.reporter.client.http.OkHttpClientImpl;
import com.testomatio.reporter.client.request.RequestBodyBuilder;
import com.testomatio.reporter.client.request.TestomatRequestBodyBuilder;
import com.testomatio.reporter.client.util.RequestUrlBuilderUtil;
import com.testomatio.reporter.exception.FinishReportFailedException;
import com.testomatio.reporter.exception.ReportingFailedException;
import com.testomatio.reporter.exception.RunCreationFailedException;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.model.TestResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class TestomatApiClient
implements ApiInterface {
    private final Logger LOGGER = LoggerUtils.getLogger(TestomatApiClient.class);
    private final String apiKey;
    private final HttpClient httpClient;
    private final RequestBodyBuilder requestBodyBuilder;

    public TestomatApiClient(String apiKey) {
        this(apiKey, new OkHttpClientImpl(), new TestomatRequestBodyBuilder());
    }

    public TestomatApiClient(String apiKey, HttpClient httpClient, TestomatRequestBodyBuilder requestBodyBuilder) {
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        this.requestBodyBuilder = requestBodyBuilder;
    }

    @Override
    public String createRun(String title) throws IOException {
        this.LOGGER.fine("Creating run with title: " + title);
        String url = RequestUrlBuilderUtil.buildCreateRunUrl();
        this.LOGGER.finer("Creating run with request url: " + url);
        String requestBody = this.requestBodyBuilder.buildCreateRunBody(title);
        Map responseBody = this.httpClient.post(url, requestBody, Map.class);
        if (responseBody == null || !responseBody.containsKey("uid")) {
            throw new RunCreationFailedException("Invalid response: missing UID in create test run response");
        }
        this.LOGGER.fine("Created test run with UID: " + (String)responseBody.get("uid"));
        this.LOGGER.info("Testomat.io java reporter version: 0.1.0");
        this.LOGGER.info("See run aggregation at: " + (String)responseBody.get("url"));
        return (String)responseBody.get("uid");
    }

    @Override
    public void reportTest(String uid, TestResult result) {
        try {
            this.LOGGER.fine("Reporting test result for testId: " + result.getTestId());
            String url = RequestUrlBuilderUtil.buildReportTestUrl(uid);
            String requestBody = this.requestBodyBuilder.buildSingleTestReportBody(result);
            this.LOGGER.finest("-----" + requestBody);
            this.httpClient.post(url, requestBody, null);
        }
        catch (Exception e) {
            throw new ReportingFailedException("Failed to report test /n" + e.getMessage());
        }
    }

    @Override
    public void reportTests(String uid, List<TestResult> results) {
        try {
            if (results == null || results.isEmpty()) {
                this.LOGGER.fine("No test results to report");
                return;
            }
            this.LOGGER.finer("Reporting batch of %d test results" + results.size());
            String url = RequestUrlBuilderUtil.buildReportTestUrl(uid);
            String requestBody = this.requestBodyBuilder.buildBatchTestReportBody(results, this.apiKey);
            this.httpClient.post(url, requestBody, null);
        }
        catch (Exception e) {
            this.LOGGER.severe("Failed to report batch test /n" + e.getMessage());
            throw new ReportingFailedException("Failed to report batch /n" + e.getMessage());
        }
    }

    @Override
    public void finishTestRun(String uid, float duration) {
        try {
            this.LOGGER.fine("Finishing test run with uid: " + uid);
            String url = RequestUrlBuilderUtil.buildFinishTestRunUrl(uid);
            String requestBody = this.requestBodyBuilder.buildFinishRunBody(duration);
            this.httpClient.put(url, requestBody, null);
        }
        catch (Exception e) {
            this.LOGGER.severe("Failed to finish test run with uid: " + uid);
            throw new FinishReportFailedException("Failed to finish test run " + e.getMessage());
        }
    }
}

