/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.testomatio.reporter.client.http.HttpClient;
import com.testomatio.reporter.constants.CommonConstants;
import com.testomatio.reporter.logger.LoggerUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpClientImpl
implements HttpClient {
    private final Logger LOGGER = LoggerUtils.getLogger(OkHttpClientImpl.class);
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <T> T post(String url, String requestBody, Class<T> responseType) throws IOException {
        Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)CommonConstants.MEDIA_TYPE_JSON, (String)requestBody)).build();
        return this.executeRequest(request, responseType);
    }

    @Override
    public <T> T put(String url, String requestBody, Class<T> responseType) throws IOException {
        Request request = new Request.Builder().url(url).put(RequestBody.create((MediaType)CommonConstants.MEDIA_TYPE_JSON, (String)requestBody)).build();
        return this.executeRequest(request, responseType);
    }

    private <T> T executeRequest(Request request, Class<T> responseType) throws IOException {
        LoggerUtils.getLogger(HttpClient.class).finer("Making request to: " + request.url());
        try (Response response = this.client.newCall(request).execute();){
            String responseBodyString;
            String string = responseBodyString = response.body() != null ? response.body().string() : "No response body";
            if (!response.isSuccessful()) {
                this.LOGGER.severe(String.format("API request failed: HTTP %s - %s | URL: %s | Response: %s", response.code(), response.message(), request.url(), responseBodyString));
                throw new IOException("API request failed: " + response.code() + " " + response.message());
            }
            if (responseType == null) {
                T t = null;
                return t;
            }
            Object object = this.objectMapper.readValue(responseBodyString, responseType);
            return (T)object;
        }
    }
}

