/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.testomatio.reporter.client.request.RequestBodyBuilder;
import com.testomatio.reporter.exception.FailedToCreateRunBodyException;
import com.testomatio.reporter.model.TestResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class TestomatRequestBodyBuilder
implements RequestBodyBuilder {
    private final ObjectMapper objectMapper;

    public TestomatRequestBodyBuilder() {
        this.objectMapper = new ObjectMapper();
    }

    public TestomatRequestBodyBuilder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String buildCreateRunBody(String title) {
        try {
            Map<String, String> body = Map.of("title", title);
            return this.objectMapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new FailedToCreateRunBodyException("Failed to create test run body", e);
        }
    }

    @Override
    public String buildSingleTestReportBody(TestResult result) throws JsonProcessingException {
        Map<String, Object> body = this.buildTestResultMap(result);
        body.put("create", "true");
        return this.objectMapper.writeValueAsString(body);
    }

    @Override
    public String buildBatchTestReportBody(List<TestResult> results, String apiKey) throws JsonProcessingException {
        ArrayList<Map<String, Object>> testsArray = new ArrayList<Map<String, Object>>();
        for (TestResult result : results) {
            testsArray.add(this.buildTestResultMap(result));
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("api_key", apiKey);
        requestBody.put("tests", testsArray);
        requestBody.put("create", "true");
        return this.objectMapper.writeValueAsString(requestBody);
    }

    @Override
    public String buildFinishRunBody(float duration) throws JsonProcessingException {
        Map<String, Float> body = Map.of("status_event", "finish", "duration", Float.valueOf(duration));
        return this.objectMapper.writeValueAsString(body);
    }

    private Map<String, Object> buildTestResultMap(TestResult result) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("create", "true");
        body.put("title", result.getTitle());
        if (result.getTestId() != null) {
            body.put("test_id", result.getTestId());
        }
        body.put("suite_title", result.getSuiteTitle());
        body.put("file", result.getFile());
        body.put("status", result.getStatus());
        if (result.getMessage() != null) {
            body.put("message", result.getMessage());
        }
        if (result.getStack() != null) {
            body.put("stack", result.getStack());
        }
        return body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestomatRequestBodyBuilder)) {
            return false;
        }
        TestomatRequestBodyBuilder other = (TestomatRequestBodyBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TestomatRequestBodyBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }
}

