/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client.util;

import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.property_config.impl.PropertyProviderFactoryImpl;
import com.testomatio.reporter.property_config.interf.PropertyProvider;
import java.util.Objects;
import okhttp3.HttpUrl;

public class RequestUrlBuilderUtil {
    private static final String API_PATH = "api";
    private static final String REPORTER_PATH = "reporter";
    private static final String TEST_RUN_PATH = "testrun";

    private RequestUrlBuilderUtil() {
    }

    public static String buildCreateRunUrl() {
        String baseUrl = RequestUrlBuilderUtil.getBaseUrl();
        String apiKey = RequestUrlBuilderUtil.getApiKey();
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)baseUrl), "Invalid base URL: " + baseUrl).newBuilder().addPathSegment(API_PATH).addPathSegment(REPORTER_PATH).addQueryParameter("api_key", apiKey).build();
        String urlString = url.toString();
        LoggerUtils.getLogger(RequestUrlBuilderUtil.class).finer("Built create test run URL: " + urlString);
        return urlString;
    }

    public static String buildReportTestUrl(String testRunUid) {
        if (testRunUid == null || testRunUid.trim().isEmpty()) {
            throw new IllegalArgumentException("Test run UID cannot be null or empty");
        }
        String baseUrl = RequestUrlBuilderUtil.getBaseUrl();
        String apiKey = RequestUrlBuilderUtil.getApiKey();
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)baseUrl), "Invalid base URL: " + baseUrl).newBuilder().addPathSegment(API_PATH).addPathSegment(REPORTER_PATH).addPathSegment(testRunUid.trim()).addPathSegment(TEST_RUN_PATH).addQueryParameter("api_key", apiKey).build();
        String urlString = url.toString();
        LoggerUtils.getLogger(RequestUrlBuilderUtil.class).finer("Built report test URL: " + urlString);
        return urlString;
    }

    public static String buildFinishTestRunUrl(String testRunUid) {
        if (testRunUid == null || testRunUid.trim().isEmpty()) {
            throw new IllegalArgumentException("Test run UID cannot be null or empty");
        }
        String baseUrl = RequestUrlBuilderUtil.getBaseUrl();
        String apiKey = RequestUrlBuilderUtil.getApiKey();
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)baseUrl), "Invalid base URL: " + baseUrl).newBuilder().addPathSegment(API_PATH).addPathSegment(REPORTER_PATH).addPathSegment(testRunUid.trim()).addQueryParameter("api_key", apiKey).build();
        String urlString = url.toString();
        LoggerUtils.getLogger(RequestUrlBuilderUtil.class).finer("Built finish test run URL: " + urlString);
        return urlString;
    }

    private static String getBaseUrl() {
        try {
            PropertyProvider propertyProvider = RequestUrlBuilderUtil.getPropertyProvider();
            String baseUrl = propertyProvider.getProperty("testomatio.url");
            if (baseUrl == null || baseUrl.trim().isEmpty()) {
                throw new IllegalStateException("Base URL not configured. Please set property: testomatio.url");
            }
            if (!(baseUrl = baseUrl.trim()).startsWith("http://") && !baseUrl.startsWith("https://")) {
                throw new IllegalStateException("Invalid base URL format. Must start with http:// or https://. Got: " + baseUrl);
            }
            return baseUrl;
        }
        catch (Exception e) {
            LoggerUtils.getLogger(RequestUrlBuilderUtil.class).severe("Failed to get base URL from properties" + e.getCause());
            throw new IllegalStateException("Failed to load base URL configuration", e);
        }
    }

    private static String getApiKey() {
        try {
            PropertyProvider propertyProvider = RequestUrlBuilderUtil.getPropertyProvider();
            String apiKey = propertyProvider.getProperty("testomatio.api.key");
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalStateException("API key not configured. Please set property: testomatio.api.key");
            }
            return apiKey.trim();
        }
        catch (Exception e) {
            LoggerUtils.getLogger(RequestUrlBuilderUtil.class).severe("Failed to get API key from properties" + e.getCause());
            throw new IllegalStateException("Failed to load API key configuration", e);
        }
    }

    private static PropertyProvider getPropertyProvider() {
        try {
            return PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
        }
        catch (Exception e) {
            LoggerUtils.getLogger(RequestUrlBuilderUtil.class).severe("Failed to create PropertyProvider" + e.getCause());
            throw new IllegalStateException("Failed to initialize property provider", e);
        }
    }
}

