/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core;

import com.testomatio.reporter.client.ApiInterface;
import com.testomatio.reporter.client.ClientFactory;
import com.testomatio.reporter.client.TestomatClientFactory;
import com.testomatio.reporter.core.batch.BatchResultManager;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.model.TestResult;
import com.testomatio.reporter.property_config.impl.PropertyProviderFactoryImpl;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class GlobalRunManager {
    private static final GlobalRunManager INSTANCE = new GlobalRunManager();
    private final AtomicInteger activeSuites = new AtomicInteger(0);
    private final AtomicReference<String> runUid = new AtomicReference();
    private final AtomicReference<BatchResultManager> batchManager = new AtomicReference();
    private final AtomicReference<ApiInterface> apiClient = new AtomicReference();
    private final AtomicBoolean shutdownHookRegistered = new AtomicBoolean(false);
    private final Logger LOGGER = LoggerUtils.getLogger(GlobalRunManager.class);
    private volatile long startTime;

    private GlobalRunManager() {
    }

    public static GlobalRunManager getInstance() {
        return INSTANCE;
    }

    public synchronized void initializeIfNeeded() {
        if (this.runUid.get() != null) {
            return;
        }
        try {
            ClientFactory clientFactory = TestomatClientFactory.getClientFactory();
            ApiInterface client = clientFactory.createClient();
            String uid = client.createRun(this.getRunTitle());
            this.apiClient.set(client);
            this.runUid.set(uid);
            this.batchManager.set(new BatchResultManager(client, uid));
            this.startTime = System.currentTimeMillis();
            this.registerShutdownHook();
            this.LOGGER.fine("Global test run initialized with UID: " + uid);
        }
        catch (Exception e) {
            this.LOGGER.severe("Failed to initialize test run: " + e);
        }
    }

    private void registerShutdownHook() {
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.LOGGER.info("JVM is shutting down, finalizing test run...");
                this.finalizeRun();
            }, "TestRunFinalizer"));
            this.LOGGER.finer("Shutdown hook registered for test run finalization");
        }
    }

    public void incrementSuiteCounter() {
        this.activeSuites.incrementAndGet();
        this.initializeIfNeeded();
    }

    public void decrementSuiteCounter() {
        int remaining = this.activeSuites.decrementAndGet();
        this.LOGGER.finer("Active suites remaining: " + remaining);
    }

    public void reportTest(TestResult result) {
        BatchResultManager manager = this.batchManager.get();
        if (manager != null) {
            manager.addResult(result);
        }
    }

    public boolean isActive() {
        return this.runUid.get() != null;
    }

    private void finalizeRun() {
        BatchResultManager manager = this.batchManager.getAndSet(null);
        if (manager != null) {
            manager.shutdown();
        }
        String uid = this.runUid.getAndSet(null);
        ApiInterface client = this.apiClient.getAndSet(null);
        if (uid != null && client != null) {
            try {
                float duration = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
                client.finishTestRun(uid, duration);
                this.LOGGER.info("Test run finished: " + uid);
            }
            catch (IOException e) {
                this.LOGGER.severe("Failed to finish test run" + e.getCause());
            }
        }
    }

    private String getRunTitle() {
        return PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider().getProperty("testomatio.run.title");
    }
}

