/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.batch;

import com.testomatio.reporter.client.ApiInterface;
import com.testomatio.reporter.logger.LoggerConfig;
import com.testomatio.reporter.model.TestResult;
import com.testomatio.reporter.property_config.impl.PropertyProviderFactoryImpl;
import com.testomatio.reporter.property_config.interf.PropertyProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class BatchResultManager {
    private static final Logger LOGGER = LoggerConfig.getLogger(BatchResultManager.class);
    private static final int DEFAULT_BATCH_SIZE = 10;
    private static final int DEFAULT_FLUSH_INTERVAL_SECONDS = 5;
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private final List<TestResult> pendingResults = new ArrayList<TestResult>();
    private final List<TestResult> failedResults = new ArrayList<TestResult>();
    private final int batchSize;
    private final ApiInterface apiClient;
    private final String runUid;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean isActive = new AtomicBoolean(true);

    public BatchResultManager(ApiInterface apiClient, String runUid) {
        this.apiClient = apiClient;
        this.runUid = runUid;
        PropertyProvider propertyProvider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
        this.batchSize = Integer.parseInt(propertyProvider.getProperty("testomatio.batch.size") != null ? propertyProvider.getProperty("testomatio.batch.size") : String.valueOf(10));
        int flushInterval = Integer.parseInt(propertyProvider.getProperty("testomatio.batch.flush.interval") != null ? propertyProvider.getProperty("testomatio.batch.flush.interval") : String.valueOf(5));
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "TestomatBatchFlush");
            t.setDaemon(true);
            return t;
        });
        this.scheduler.scheduleAtFixedRate(this::flushPendingResults, flushInterval, flushInterval, TimeUnit.SECONDS);
        LOGGER.finer(String.format("BatchResultManager initialized: batchSize= %d, flushInterval= %d sec", this.batchSize, flushInterval));
    }

    public synchronized void addResult(TestResult result) {
        if (!this.isActive.get()) {
            LOGGER.warning("BatchResultManager is not active, skipping result: " + result.getTitle());
            return;
        }
        this.pendingResults.add(result);
        LOGGER.finer(String.format("Added test result: %s (pending: %d)", result.getTitle(), this.pendingResults.size()));
        if (this.pendingResults.size() >= this.batchSize) {
            this.flushPendingResults();
        }
    }

    public synchronized void flushPendingResults() {
        if (this.pendingResults.isEmpty()) {
            return;
        }
        ArrayList<TestResult> toSend = new ArrayList<TestResult>(this.pendingResults);
        this.pendingResults.clear();
        this.sendBatch(toSend, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatch(List<TestResult> results, int attempt) {
        try {
            if (results.size() == 1) {
                this.apiClient.reportTest(this.runUid, results.get(0));
                LOGGER.finer("Reported single test: " + results.get(0).getTitle());
            } else {
                this.apiClient.reportTests(this.runUid, results);
                LOGGER.finer("Reported batch of %d tests" + results.size());
            }
        }
        catch (IOException e) {
            LOGGER.severe(String.format("Failed to report batch (attempt %d/%d): %s", attempt, 3, e.getMessage()));
            if (attempt < 3) {
                this.scheduler.schedule(() -> this.sendBatch(results, attempt + 1), (long)Math.pow(2.0, attempt), TimeUnit.SECONDS);
            }
            BatchResultManager batchResultManager = this;
            synchronized (batchResultManager) {
                this.failedResults.addAll(results);
            }
            LOGGER.severe(String.format("Failed to report %d tests after %d attempts", results.size(), 3));
        }
    }

    public synchronized void shutdown() {
        this.isActive.set(false);
        this.flushPendingResults();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        if (!this.failedResults.isEmpty()) {
            LOGGER.warning(String.format("BatchResultManager shutdown with %d failed results", this.failedResults.size()));
        }
        LOGGER.fine("BatchResultManager shutdown completed");
    }
}

