/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.constructor;

import com.testomatio.reporter.core.constructor.ExceptionDetails;
import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestCaseResultWrapper;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.model.TestMetadata;
import com.testomatio.reporter.model.TestResult;
import java.util.logging.Logger;

public abstract class AbstractTestResultConstructor
implements ResultConstructor {
    private static final Logger LOGGER = LoggerUtils.getLogger(AbstractTestResultConstructor.class);

    @Override
    public final TestResult constructTestRunResult(TestCaseResultWrapper holder) {
        this.validateHolder(holder);
        boolean hasCustomMessage = this.hasCustomMessage(holder);
        this.logTestResultCreation(holder, hasCustomMessage);
        return hasCustomMessage ? this.createWithCustomMessage(holder) : this.createWithExceptionDetails(holder);
    }

    protected final void validateHolder(TestCaseResultWrapper holder) {
        if (holder == null) {
            throw new IllegalArgumentException("TestRunResultWrapper cannot be null");
        }
        if (holder.getTestMetadata() == null) {
            throw new IllegalArgumentException("TestMetadata cannot be null");
        }
    }

    protected final void logTestResultCreation(TestCaseResultWrapper holder, boolean hasCustomMessage) {
        String testTitle = holder.getTestMetadata().getTitle();
        if (hasCustomMessage) {
            String message = this.getCustomMessage(holder);
            LOGGER.finer("Creating " + this.getFrameworkName() + " test result with custom message: " + testTitle + " - " + message);
        } else {
            LOGGER.finer("Creating " + this.getFrameworkName() + " test result with exception details for: " + testTitle);
        }
    }

    protected final TestResult.Builder buildTestResult(TestCaseResultWrapper holder) {
        TestMetadata metadata = holder.getTestMetadata();
        return TestResult.builder().withTitle(metadata.getTitle()).withTestId(metadata.getTestId()).withSuiteTitle(metadata.getSuiteTitle()).withFile(metadata.getFile()).withStatus(holder.getStatus());
    }

    protected final ExceptionDetails createExceptionDetails(Throwable throwable) {
        String message = throwable.getMessage();
        String stack = this.getStackTrace(throwable);
        LOGGER.finer("Including error details for failed test");
        return new ExceptionDetails(message, stack);
    }

    protected abstract boolean hasCustomMessage(TestCaseResultWrapper var1);

    protected abstract String getCustomMessage(TestCaseResultWrapper var1);

    protected abstract TestResult createWithCustomMessage(TestCaseResultWrapper var1);

    protected abstract TestResult createWithExceptionDetails(TestCaseResultWrapper var1);

    protected abstract String getFrameworkName();
}

