/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.constructor;

import com.testomatio.reporter.core.constructor.AbstractTestResultConstructor;
import com.testomatio.reporter.core.constructor.ExceptionDetails;
import com.testomatio.reporter.core.constructor.TestCaseResultWrapper;
import com.testomatio.reporter.model.TestResult;
import java.util.Optional;
import org.testng.ITestResult;

public class TestNGTestResultConstructor
extends AbstractTestResultConstructor {
    @Override
    protected boolean hasCustomMessage(TestCaseResultWrapper holder) {
        return holder.getReason() != null || holder.getMessage() != null;
    }

    @Override
    protected String getCustomMessage(TestCaseResultWrapper holder) {
        return Optional.ofNullable(holder.getReason()).orElse(holder.getMessage());
    }

    @Override
    protected TestResult createWithCustomMessage(TestCaseResultWrapper holder) {
        String message = this.getCustomMessage(holder);
        return this.buildTestResult(holder).withMessage(message).withStack(null).build();
    }

    @Override
    protected TestResult createWithExceptionDetails(TestCaseResultWrapper holder) {
        ExceptionDetails exceptionDetails = this.extractExceptionDetails(holder);
        return this.buildTestResult(holder).withMessage(exceptionDetails.getMessage()).withStack(exceptionDetails.getStack()).build();
    }

    @Override
    protected String getFrameworkName() {
        return "TestNG";
    }

    private ExceptionDetails extractExceptionDetails(TestCaseResultWrapper holder) {
        return Optional.ofNullable(holder.getTestResult()).map(ITestResult::getThrowable).filter(this::isReportableException).map(this::createExceptionDetails).orElse(ExceptionDetails.empty());
    }
}

