/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.extractor.wrapper;

import java.lang.reflect.Method;
import lombok.Generated;
import org.testng.ITestResult;

public class TestNGTestWrapper {
    private final ITestResult testResult;
    private final Method method;
    private final Class<?> testClass;
    private final TestType testType;

    public TestNGTestWrapper(ITestResult testResult) {
        this.testResult = testResult;
        this.method = null;
        this.testClass = null;
        this.testType = TestType.REGULAR_TEST;
    }

    public TestNGTestWrapper(Method method, Class<?> testClass) {
        this.testResult = null;
        this.method = method;
        this.testClass = testClass;
        this.testType = TestType.DISABLED_TEST;
    }

    public boolean isRegularTest() {
        return this.testType == TestType.REGULAR_TEST;
    }

    public String toString() {
        if (this.isRegularTest()) {
            assert (this.testResult != null);
            return String.format("TestNGTestWrapper{type=REGULAR_TEST, testClass=%s, method=%s}", this.testResult.getTestClass().getName(), this.testResult.getMethod().getMethodName());
        }
        assert (this.testClass != null);
        assert (this.method != null);
        return String.format("TestNGTestWrapper{type=DISABLED_TEST, testClass=%s, method=%s}", this.testClass.getSimpleName(), this.method.getName());
    }

    public static TestNGTestWrapper forRegularTest(ITestResult testResult) {
        return new TestNGTestWrapper(testResult);
    }

    public static TestNGTestWrapper forDisabledTest(Method method, Class<?> testClass) {
        return new TestNGTestWrapper(method, testClass);
    }

    @Generated
    public ITestResult getTestResult() {
        return this.testResult;
    }

    @Generated
    public Method getMethod() {
        return this.method;
    }

    @Generated
    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Generated
    public TestType getTestType() {
        return this.testType;
    }

    public static enum TestType {
        REGULAR_TEST,
        DISABLED_TEST;

    }
}

