/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.framework_integration;

import com.testomatio.reporter.core.GlobalRunManager;
import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestCaseResultWrapper;
import com.testomatio.reporter.exception.ReportTestResultException;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.model.TestMetadata;
import com.testomatio.reporter.model.TestResult;
import java.util.logging.Logger;

public abstract class AbstractTestFrameworkListener {
    protected final Logger LOGGER = LoggerUtils.getLogger(this.getClass());
    protected final GlobalRunManager runManager = GlobalRunManager.getInstance();
    protected final ResultConstructor resultConstructor = this.createResultConstructor();

    protected AbstractTestFrameworkListener() {
        this.LOGGER.fine(this.getClass().getSimpleName() + " initialized");
    }

    protected abstract ResultConstructor createResultConstructor();

    protected void handleSuiteStarted(String suiteName) {
        this.LOGGER.fine("Starting test suite: " + suiteName);
        this.runManager.incrementSuiteCounter();
        this.LOGGER.finer("Active suite count incremented for: " + suiteName);
    }

    protected void handleSuiteFinished(String suiteName) {
        this.LOGGER.fine("Finishing test suite: " + suiteName);
        this.runManager.decrementSuiteCounter();
        this.LOGGER.finer("Active suite count decremented for: " + suiteName);
    }

    protected void reportTestResult(TestMetadata metadata, String status, Object frameworkSpecificData) {
        this.reportTestResult(metadata, status, null, frameworkSpecificData);
    }

    protected void reportTestResult(TestMetadata metadata, String status, String message, Object frameworkSpecificData) {
        if (!this.runManager.isActive()) {
            this.LOGGER.fine("Test run manager is not active, skipping test result reporting");
            return;
        }
        try {
            TestResult result = this.createTestResult(metadata, status, message, frameworkSpecificData);
            this.logAndReportResult(result, status, message);
        }
        catch (Exception e) {
            String testName = metadata != null ? metadata.getTitle() : "Unknown Test";
            this.LOGGER.severe("Failed to report test result for: " + testName);
            throw new ReportTestResultException("Failed to report test result for: " + testName, e);
        }
    }

    protected TestResult createTestResult(TestMetadata metadata, String status, String message, Object frameworkSpecificData) {
        TestCaseResultWrapper holder = this.buildTestRunResultHolder(metadata, status, message, frameworkSpecificData);
        return this.resultConstructor.constructTestRunResult(holder);
    }

    protected TestCaseResultWrapper buildTestRunResultHolder(TestMetadata metadata, String status, String message, Object frameworkSpecificData) {
        TestCaseResultWrapper.Builder builder = TestCaseResultWrapper.builder().withTestMetadata(metadata).withStatus(status);
        if (message != null) {
            builder.withMessage(message);
        }
        this.addFrameworkSpecificData(builder, frameworkSpecificData);
        return builder.build();
    }

    protected abstract void addFrameworkSpecificData(TestCaseResultWrapper.Builder var1, Object var2);

    protected void logAndReportResult(TestResult result, String status, String message) {
        this.logTestReporting(result, status, message);
        this.runManager.reportTest(result);
        this.logTestReported(result);
        this.LOGGER.finer("Test result reported successfully: " + result.getTitle());
    }

    protected void logMetadataCreation(TestMetadata metadata) {
        this.LOGGER.finer("Created TestMetadata: Title=" + metadata.getTitle() + ", TestId=" + metadata.getTestId() + ", Suite=" + metadata.getSuiteTitle() + ", File=" + metadata.getFile());
        if (metadata.getTestId() != null) {
            this.LOGGER.fine("TestMetadata contains TestId: " + metadata.getTestId() + " which will be sent as test_id field");
        }
    }

    protected void logTestReporting(TestResult result, String status, String message) {
        if (result.getTestId() != null) {
            Object logMessage = String.format("Reporting test with TestId: %s | Test: %s | Status: %s", result.getTestId(), result.getTitle(), status);
            if (message != null) {
                logMessage = (String)logMessage + " | Message: " + message;
            }
            this.LOGGER.info((String)logMessage);
        } else {
            String logMessage = "Reporting test without TestId: " + result.getTitle() + " - " + status;
            if (message != null) {
                logMessage = logMessage + " | Message: " + message;
            }
            this.LOGGER.fine(logMessage);
        }
    }

    protected void logTestReported(TestResult result) {
        if (result.getTestId() != null) {
            this.LOGGER.fine("\u2713 TestId " + result.getTestId() + " successfully sent to Testomat.io as test_id field");
        }
    }

    protected String normalizeStatus(Object frameworkStatus) {
        String statusStr;
        if (frameworkStatus == null) {
            return "failed";
        }
        switch (statusStr = frameworkStatus.toString().toUpperCase()) {
            case "PASSED": 
            case "SUCCESS": 
            case "SUCCESSFUL": {
                return "passed";
            }
            case "SKIPPED": 
            case "PENDING": 
            case "UNDEFINED": 
            case "AMBIGUOUS": 
            case "DISABLED": 
            case "ABORTED": {
                return "skipped";
            }
        }
        return "failed";
    }
}

