/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.framework_integration;

import com.testomatio.reporter.core.constructor.JUnitTestResultConstructor;
import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestCaseResultWrapper;
import com.testomatio.reporter.core.extractor.JUnitMetaDataExtractor;
import com.testomatio.reporter.core.extractor.MetaDataExtractor;
import com.testomatio.reporter.core.extractor.wrapper.JUnitTestWrapper;
import com.testomatio.reporter.core.framework_integration.AbstractTestFrameworkListener;
import com.testomatio.reporter.model.TestMetadata;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class JUnitExtension
extends AbstractTestFrameworkListener
implements BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback,
TestWatcher {
    private final MetaDataExtractor<JUnitTestWrapper> jUnitMetaDataExtractor = new JUnitMetaDataExtractor();

    @Override
    protected ResultConstructor createResultConstructor() {
        return new JUnitTestResultConstructor();
    }

    @Override
    protected void addFrameworkSpecificData(TestCaseResultWrapper.Builder builder, Object frameworkSpecificData) {
        if (frameworkSpecificData instanceof ExtensionContext) {
            builder.withJUnitExtensionContext((ExtensionContext)frameworkSpecificData);
        }
    }

    public void beforeAll(ExtensionContext context) {
        String className = context.getTestClass().map(Class::getSimpleName).orElse("Unknown");
        this.handleSuiteStarted(className);
    }

    public void afterAll(ExtensionContext context) {
        String className = context.getTestClass().map(Class::getSimpleName).orElse("Unknown");
        this.handleSuiteFinished(className);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.LOGGER.finer("Starting test run: " + extensionContext.getDisplayName());
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        String reasonText = reason.orElse("Test disabled");
        this.LOGGER.fine(String.format("Test disabled: %s - Reason: %s", context.getDisplayName(), reasonText));
        this.handleTestResult(context, "skipped", reasonText);
    }

    public void testSuccessful(ExtensionContext context) {
        this.LOGGER.fine("Test passed successfully: " + context.getDisplayName());
        this.handleTestResult(context, "passed", null);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        this.LOGGER.fine(String.format("Test aborted: %s - Cause: %s", context.getDisplayName(), cause.getMessage()));
        this.handleTestResult(context, "skipped", cause.getMessage());
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        this.LOGGER.fine(String.format("Test failed: %s - Cause: %s", context.getDisplayName(), cause.getMessage()));
        this.handleTestResult(context, "failed", cause.getMessage());
    }

    private void handleTestResult(ExtensionContext context, String status, String message) {
        Optional testMethodOptional = context.getTestMethod();
        if (testMethodOptional.isEmpty()) {
            this.LOGGER.warning("No test method found in context, cannot report test result");
            return;
        }
        Method testMethod = (Method)testMethodOptional.get();
        JUnitTestWrapper testWrapper = new JUnitTestWrapper(testMethod, context);
        TestMetadata metadata = this.jUnitMetaDataExtractor.extractTestMetadata(testWrapper);
        this.logMetadataCreation(metadata);
        this.reportTestResult(metadata, status, message, context);
    }
}

