/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.framework_integration;

import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestCaseResultWrapper;
import com.testomatio.reporter.core.constructor.TestNGTestResultConstructor;
import com.testomatio.reporter.core.extractor.MetaDataExtractor;
import com.testomatio.reporter.core.extractor.TestNGMetaDataExtractor;
import com.testomatio.reporter.core.extractor.wrapper.TestNGTestWrapper;
import com.testomatio.reporter.core.framework_integration.AbstractTestFrameworkListener;
import com.testomatio.reporter.model.TestMetadata;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class TestNGListener
extends AbstractTestFrameworkListener
implements ISuiteListener,
ITestListener,
IInvokedMethodListener {
    private static final String DISABLED_MESSAGE = "Test disabled via @Test(enabled = false)";
    private final MetaDataExtractor<TestNGTestWrapper> metaDataExtractor = new TestNGMetaDataExtractor();
    private final Set<String> processedTests = new HashSet<String>();

    @Override
    protected ResultConstructor createResultConstructor() {
        return new TestNGTestResultConstructor();
    }

    @Override
    protected void addFrameworkSpecificData(TestCaseResultWrapper.Builder builder, Object frameworkSpecificData) {
        if (frameworkSpecificData instanceof ITestResult) {
            builder.withTestResult((ITestResult)frameworkSpecificData);
        }
    }

    public void onStart(ISuite suite) {
        this.handleSuiteStarted(suite.getName());
        this.checkAndReportDisabledTests(suite);
    }

    public void onFinish(ISuite suite) {
        this.handleSuiteFinished(suite.getName());
    }

    public void onTestSuccess(ITestResult result) {
        this.handleTestNGResult(result, "passed");
    }

    public void onTestFailure(ITestResult result) {
        this.handleTestNGResult(result, "failed");
    }

    public void onTestSkipped(ITestResult result) {
        this.handleTestNGResult(result, "skipped");
    }

    private void handleTestNGResult(ITestResult result, String status) {
        String methodKey = result.getTestClass().getName() + "." + result.getMethod().getMethodName();
        if (this.processedTests.contains(methodKey)) {
            return;
        }
        this.processedTests.add(methodKey);
        TestNGTestWrapper wrapper = TestNGTestWrapper.forRegularTest(result);
        TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(wrapper);
        this.logMetadataCreation(metadata);
        this.reportTestResult(metadata, status, result);
    }

    private void checkAndReportDisabledTests(ISuite suite) {
        if (!this.runManager.isActive()) {
            return;
        }
        suite.getXmlSuite().getTests().forEach(xmlTest -> xmlTest.getXmlClasses().forEach(xmlClass -> {
            try {
                Method[] methods;
                Class<?> testClass = Class.forName(xmlClass.getName());
                for (Method method : methods = testClass.getDeclaredMethods()) {
                    String methodKey;
                    Test testAnnotation = method.getAnnotation(Test.class);
                    if (testAnnotation == null || testAnnotation.enabled() || this.processedTests.contains(methodKey = xmlClass.getName() + "." + method.getName())) continue;
                    this.processedTests.add(methodKey);
                    this.reportDisabledTest(method, testClass);
                    this.LOGGER.finer("Reported disabled test: " + methodKey);
                }
            }
            catch (ClassNotFoundException e) {
                this.LOGGER.severe(String.format("Could not load test class for: %s \n %s \n %s", xmlClass.getName(), e.getCause(), e.getMessage()));
            }
        }));
    }

    private void reportDisabledTest(Method method, Class<?> testClass) {
        TestNGTestWrapper wrapper = TestNGTestWrapper.forDisabledTest(method, testClass);
        TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(wrapper);
        this.logMetadataCreation(metadata);
        this.reportTestResult(metadata, "skipped", DISABLED_MESSAGE, null);
        this.LOGGER.fine(String.format("Disabled test reported: %s - %s", metadata.getTitle(), DISABLED_MESSAGE));
    }
}

