/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.logger;

import com.testomatio.reporter.property_config.impl.PropertyProviderFactoryImpl;
import com.testomatio.reporter.property_config.interf.PropertyProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggerConfig {
    private static final String ROOT_LOGGER_NAME = "com.testomatio.reporter";
    private static volatile boolean initialized = false;
    private static PropertyProvider propertyProvider;

    public static synchronized void ensureInitialized() {
        if (initialized) {
            return;
        }
        try {
            propertyProvider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
            LoggerConfig.initialize();
        }
        catch (Exception e) {
            System.err.println("[TESTOMATIO] Logger initialization failed: " + e.getMessage());
            LoggerConfig.setupFallback();
        }
        initialized = true;
    }

    public static Logger getLogger(String name) {
        LoggerConfig.ensureInitialized();
        return Logger.getLogger("com.testomatio.reporter." + name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerConfig.getLogger(clazz.getSimpleName());
    }

    private static void initialize() {
        String consoleEnabled;
        Logger rootLogger = Logger.getLogger(ROOT_LOGGER_NAME);
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.setUseParentHandlers(false);
        String levelStr = LoggerConfig.getProperty("testomatio.log.level");
        Level level = LoggerConfig.parseLevel(levelStr);
        rootLogger.setLevel(level);
        boolean hasHandlers = false;
        String logFile = LoggerConfig.getProperty("testomatio.log.file");
        if (logFile != null && !logFile.trim().isEmpty()) {
            hasHandlers |= LoggerConfig.addFileHandler(rootLogger, logFile.trim(), level);
        }
        if (!"false".equalsIgnoreCase(consoleEnabled = LoggerConfig.getProperty("testomatio.log.console"))) {
            hasHandlers |= LoggerConfig.addConsoleHandler(rootLogger, level);
        }
        if (!hasHandlers) {
            LoggerConfig.addConsoleHandler(rootLogger, level);
        }
    }

    private static Level parseLevel(String levelStr) {
        if (levelStr == null || levelStr.trim().isEmpty()) {
            return Level.INFO;
        }
        try {
            return Level.parse(levelStr.toUpperCase().trim());
        }
        catch (IllegalArgumentException e) {
            System.err.println("[TESTOMATIO] Invalid log level '" + levelStr + "'. Using INFO.");
            return Level.INFO;
        }
    }

    private static boolean addFileHandler(Logger logger, String fileName, Level level) {
        try {
            Path path = Paths.get(fileName, new String[0]);
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            FileHandler handler = new FileHandler(fileName, true);
            handler.setFormatter(new SimpleFormatter());
            handler.setLevel(level);
            logger.addHandler(handler);
            return true;
        }
        catch (IOException e) {
            System.err.println("[TESTOMATIO] Failed to setup file logging: " + e.getMessage());
            return false;
        }
    }

    private static boolean addConsoleHandler(Logger logger, Level level) {
        try {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(new SimpleFormatter());
            handler.setLevel(level);
            logger.addHandler(handler);
            return true;
        }
        catch (Exception e) {
            System.err.println("[TESTOMATIO] Failed to setup console logging: " + e.getMessage());
            return false;
        }
    }

    private static void setupFallback() {
        try {
            Logger rootLogger = Logger.getLogger(ROOT_LOGGER_NAME);
            rootLogger.setUseParentHandlers(false);
            if (rootLogger.getHandlers().length == 0) {
                ConsoleHandler handler = new ConsoleHandler();
                handler.setFormatter(new SimpleFormatter());
                handler.setLevel(Level.INFO);
                rootLogger.addHandler(handler);
                rootLogger.setLevel(Level.INFO);
                System.out.println("[TESTOMATIO] Fallback console logging enabled");
            }
        }
        catch (Exception e) {
            System.err.println("[TESTOMATIO] Complete logging setup failure: " + e.getMessage());
        }
    }

    private static String getProperty(String key) {
        return propertyProvider != null ? propertyProvider.getProperty(key) : null;
    }
}

