/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.property_config.provider;

import com.testomatio.reporter.exception.NoPropertyFileException;
import com.testomatio.reporter.exception.PropertyNotFoundException;
import com.testomatio.reporter.property_config.interf.AbstractPropertyProvider;
import com.testomatio.reporter.property_config.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class FilePropertyProvider
extends AbstractPropertyProvider {
    private final Logger LOGGER = Logger.getLogger(FilePropertyProvider.class.getName());

    @Override
    public String getProperty(String key) {
        String formatedKey;
        Properties properties = this.loadProperties();
        String value = properties.getProperty(formatedKey = StringUtils.fromEnvStyle(key));
        if (!StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        if (this.next != null) {
            return this.next.getProperty(key);
        }
        throw new PropertyNotFoundException("No such property: " + key);
    }

    private Properties loadProperties() {
        Properties properties = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("testomatio.properties");){
            if (input != null) {
                properties.load(input);
            }
        }
        catch (IOException e) {
            this.LOGGER.severe("Error loading properties file: " + e.getMessage());
            throw new NoPropertyFileException("Error loading properties file: " + e.getMessage());
        }
        return properties;
    }
}

