/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.property_config.provider;

import com.testomatio.reporter.exception.PropertyNotFoundException;
import com.testomatio.reporter.property_config.interf.AbstractPropertyProvider;
import com.testomatio.reporter.property_config.util.StringUtils;
import java.util.logging.Logger;

public class SystemEnvPropertyProvider
extends AbstractPropertyProvider {
    private final Logger LOGGER = Logger.getLogger(SystemEnvPropertyProvider.class.getName());

    @Override
    public String getProperty(String key) {
        String formattedKey = StringUtils.toEnvStyle(key);
        String value = System.getenv(formattedKey);
        if (!StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        if (this.next != null) {
            return this.next.getProperty(key);
        }
        this.LOGGER.finer("No system environment variable provided for key: " + key);
        throw new PropertyNotFoundException("No such property: " + key);
    }
}

