/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client;

import com.testomatio.reporter.client.ApiInterface;
import com.testomatio.reporter.client.http.CustomHttpClient;
import com.testomatio.reporter.client.request.DefaultRequestBodyBuilder;
import com.testomatio.reporter.client.request.RequestBodyBuilder;
import com.testomatio.reporter.client.urlbuilder.NativeUrlBuilder;
import com.testomatio.reporter.client.urlbuilder.UrlBuilder;
import com.testomatio.reporter.exception.FinishReportFailedException;
import com.testomatio.reporter.exception.ReportingFailedException;
import com.testomatio.reporter.exception.RunCreationFailedException;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.model.TestResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DefaultApiClient
implements ApiInterface {
    private static final Logger LOGGER = LoggerUtils.getLogger(DefaultApiClient.class);
    private final UrlBuilder urlBuilder = new NativeUrlBuilder();
    private final String apiKey;
    private final CustomHttpClient client;
    private final RequestBodyBuilder requestBodyBuilder;

    public DefaultApiClient(String apiKey, CustomHttpClient client, DefaultRequestBodyBuilder requestBodyBuilder) {
        this.apiKey = apiKey;
        this.client = client;
        this.requestBodyBuilder = requestBodyBuilder;
    }

    @Override
    public String createRun(String title) throws IOException {
        LOGGER.fine("Creating run with title: " + title);
        String url = this.urlBuilder.buildCreateRunUrl();
        LOGGER.finer("Creating run with request url: " + url);
        String requestBody = this.requestBodyBuilder.buildCreateRunBody(title);
        Map responseBody = this.client.post(url, requestBody, Map.class);
        LOGGER.fine(responseBody.toString());
        if (responseBody == null || !responseBody.containsKey("uid")) {
            throw new RunCreationFailedException("Invalid response: missing UID in create test run response");
        }
        LOGGER.info("[TESTOMATIO] Testomat.io java reporter version: [0.1.0]");
        LOGGER.info("[TESTOMATIO] Public url: " + (String)responseBody.get("public_url"));
        LOGGER.fine("Created test run with UID: " + (String)responseBody.get("uid"));
        LOGGER.info("[TESTOMATIO] See run aggregation at: " + (String)responseBody.get("url"));
        return (String)responseBody.get("uid");
    }

    @Override
    public void reportTest(String uid, TestResult result) {
        try {
            LOGGER.fine("Reporting test result for testId: " + result.getTestId());
            String url = this.urlBuilder.buildReportTestUrl(uid);
            String requestBody = this.requestBodyBuilder.buildSingleTestReportBody(result);
            LOGGER.finest("-----" + requestBody);
            this.client.post(url, requestBody, null);
        }
        catch (Exception e) {
            throw new ReportingFailedException("Failed to report test /n" + e.getMessage());
        }
    }

    @Override
    public void reportTests(String uid, List<TestResult> results) {
        try {
            if (results == null || results.isEmpty()) {
                LOGGER.fine("No test results to report");
                return;
            }
            LOGGER.finer("Reporting batch of %d test results" + results.size());
            String url = this.urlBuilder.buildReportTestUrl(uid);
            String requestBody = this.requestBodyBuilder.buildBatchTestReportBody(results, this.apiKey);
            this.client.post(url, requestBody, null);
        }
        catch (Exception e) {
            LOGGER.severe("Failed to report batch test /n" + e.getMessage());
            throw new ReportingFailedException("Failed to report batch /n" + e.getMessage());
        }
    }

    @Override
    public void finishTestRun(String uid, float duration) {
        try {
            LOGGER.fine("Finishing test run with uid: " + uid);
            String url = this.urlBuilder.buildFinishTestRunUrl(uid);
            String requestBody = this.requestBodyBuilder.buildFinishRunBody(duration);
            this.client.put(url, requestBody, null);
        }
        catch (Exception e) {
            LOGGER.severe("Failed to finish test run with uid: " + uid);
            throw new FinishReportFailedException("Failed to finish test run " + e.getMessage());
        }
    }
}

