/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client;

import com.testomatio.reporter.client.ApiInterface;
import com.testomatio.reporter.client.ClientFactory;
import com.testomatio.reporter.client.DefaultApiClient;
import com.testomatio.reporter.client.http.NativeHttpClient;
import com.testomatio.reporter.client.request.DefaultRequestBodyBuilder;
import com.testomatio.reporter.exception.ApiKeyNotFoundException;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.propertyconfig.impl.PropertyProviderFactoryImpl;
import com.testomatio.reporter.propertyconfig.interf.PropertyProvider;
import java.util.logging.Logger;

public class TestomatClientFactory
implements ClientFactory {
    private static final PropertyProvider propertyProvider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
    private static final Logger LOGGER = LoggerUtils.getLogger(TestomatClientFactory.class);
    private static ClientFactory instance;

    private TestomatClientFactory() {
    }

    public static ClientFactory getClientFactory() {
        if (instance == null) {
            instance = new TestomatClientFactory();
        }
        return instance;
    }

    @Override
    public ApiInterface createClient() {
        String apiKey = propertyProvider.getProperty("testomatio.api.key");
        if (apiKey == null) {
            LOGGER.severe("Api key environment variable not set.");
            throw new ApiKeyNotFoundException("Api key should be set in properties file or in JVM params.");
        }
        return new DefaultApiClient(apiKey, new NativeHttpClient(), new DefaultRequestBodyBuilder());
    }
}

