/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.testomatio.reporter.client.request.RequestBodyBuilder;
import com.testomatio.reporter.exception.FailedToCreateRunBodyException;
import com.testomatio.reporter.model.TestResult;
import com.testomatio.reporter.propertyconfig.impl.PropertyProviderFactoryImpl;
import com.testomatio.reporter.propertyconfig.interf.PropertyProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultRequestBodyBuilder
implements RequestBodyBuilder {
    private final String createParam;
    private final String sharedRun;
    private final String sharedRunTimeout;
    private final String publishParam;
    private final ObjectMapper objectMapper;
    private final PropertyProvider provider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();

    public DefaultRequestBodyBuilder() {
        this.publishParam = this.getPublishProperty();
        this.sharedRun = this.getSharedRunProperty();
        this.sharedRunTimeout = this.getSharedRunTimeoutProperty();
        this.objectMapper = new ObjectMapper();
        this.createParam = this.getCreateParamProperty();
    }

    @Override
    public String buildCreateRunBody(String title) {
        try {
            String groupTitle;
            HashMap<String, String> body = new HashMap<String, String>(Map.of("title", title));
            String customEnv = this.getCustomEnvironmentProperty();
            if (customEnv != null) {
                body.put("env", customEnv);
            }
            if ((groupTitle = this.getRunGroupTitleProperty()) != null) {
                body.put("group_title", groupTitle);
            }
            if (this.sharedRun != null) {
                body.put("shared_run", this.sharedRun);
            }
            if (this.sharedRunTimeout != null) {
                body.put("shared_run_timeout", this.sharedRunTimeout);
            }
            if (this.publishParam != null) {
                body.put("access_event", "publish");
            }
            return this.objectMapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new FailedToCreateRunBodyException("Failed to create test run body", e);
        }
    }

    @Override
    public String buildSingleTestReportBody(TestResult result) throws JsonProcessingException {
        Map<String, Object> body = this.buildTestResultMap(result);
        return this.objectMapper.writeValueAsString(body);
    }

    @Override
    public String buildBatchTestReportBody(List<TestResult> results, String apiKey) throws JsonProcessingException {
        ArrayList<Map<String, Object>> testsArray = new ArrayList<Map<String, Object>>();
        for (TestResult result : results) {
            testsArray.add(this.buildTestResultMap(result));
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("api_key", apiKey);
        requestBody.put("tests", testsArray);
        return this.objectMapper.writeValueAsString(requestBody);
    }

    @Override
    public String buildFinishRunBody(float duration) throws JsonProcessingException {
        Map<String, Float> body = Map.of("status_event", "finish", "duration", Float.valueOf(duration));
        return this.objectMapper.writeValueAsString(body);
    }

    private Map<String, Object> buildTestResultMap(TestResult result) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", result.getTitle());
        if (result.getTestId() != null) {
            body.put("test_id", result.getTestId());
        }
        body.put("suite_title", result.getSuiteTitle());
        body.put("file", result.getFile());
        body.put("status", result.getStatus());
        if (result.getMessage() != null) {
            body.put("message", result.getMessage());
        }
        if (result.getStack() != null) {
            body.put("stack", result.getStack());
        }
        if (this.createParam != null) {
            body.put("create", "true");
        }
        return body;
    }

    private String getCustomEnvironmentProperty() {
        try {
            return this.provider.getProperty("testomatio.env");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getRunGroupTitleProperty() {
        try {
            return this.provider.getProperty("testomatio.run.group");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCreateParamProperty() {
        try {
            return this.provider.getProperty("testomatio.create");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getSharedRunProperty() {
        try {
            return this.provider.getProperty("testomatio.shared.run");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getSharedRunTimeoutProperty() {
        try {
            return this.provider.getProperty("testomatio.shared.run.timeout");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getPublishProperty() {
        try {
            return this.provider.getProperty("testomatio.publish");
        }
        catch (Exception e) {
            return null;
        }
    }
}

