/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.client.urlbuilder;

import com.testomatio.reporter.client.urlbuilder.UrlBuilder;
import com.testomatio.reporter.exception.InvalidProvidedPropertyException;
import com.testomatio.reporter.exception.UrlBuildingException;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.propertyconfig.impl.PropertyProviderFactoryImpl;
import com.testomatio.reporter.propertyconfig.interf.PropertyProvider;
import com.testomatio.reporter.propertyconfig.interf.PropertyProviderFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

public class NativeUrlBuilder
implements UrlBuilder {
    private static final Logger LOGGER = LoggerUtils.getLogger(NativeUrlBuilder.class);
    private static final String API_REPORTER_PATH = "/api/reporter";
    private static final String TEST_RUN_PATH = "/testrun";
    private static final String API_KEY_PARAM = "api_key=";
    private static final String PARAMS_START_MARK = "?";
    private final PropertyProviderFactory factory = PropertyProviderFactoryImpl.getPropertyProviderFactory();
    private final PropertyProvider provider = this.factory.getPropertyProvider();

    @Override
    public String buildCreateRunUrl() {
        String baseUrl = this.getBaseUrl();
        String apiKey = this.getApiKey();
        String encodedApiKey = URLEncoder.encode(apiKey, StandardCharsets.UTF_8);
        String urlString = baseUrl + "/api/reporter?api_key=" + encodedApiKey;
        this.validateBuiltUrl(urlString);
        return urlString;
    }

    @Override
    public String buildReportTestUrl(String testRunUid) {
        this.validateTestRunId(testRunUid);
        String apiKey = this.getApiKey();
        String encodedApiKey = URLEncoder.encode(apiKey, StandardCharsets.UTF_8);
        String baseUrl = this.getBaseUrl();
        String urlString = baseUrl + "/api/reporter/" + testRunUid.trim() + "/testrun?api_key=" + encodedApiKey;
        this.validateBuiltUrl(urlString);
        return urlString;
    }

    @Override
    public String buildFinishTestRunUrl(String testRunUid) {
        this.validateTestRunId(testRunUid);
        String apiKey = this.getApiKey();
        String encodedApiKey = URLEncoder.encode(apiKey, StandardCharsets.UTF_8);
        String baseUrl = this.getBaseUrl();
        String urlString = baseUrl + "/api/reporter/" + testRunUid.trim() + "?api_key=" + encodedApiKey;
        this.validateBuiltUrl(urlString);
        return urlString;
    }

    private String getBaseUrl() {
        String baseUrl = this.provider.getProperty("testomatio.url");
        this.validateProvidedUrl(baseUrl);
        return this.normalizeUrl(baseUrl);
    }

    private void validateProvidedUrl(String providedUrl) {
        if (providedUrl == null || providedUrl.trim().isEmpty()) {
            String message = "Base URL is required. Please set property: testomatio.url";
            LOGGER.warning(message);
            throw new InvalidProvidedPropertyException(message);
        }
        String trimmedProvidedUrl = providedUrl.trim();
        if (!trimmedProvidedUrl.startsWith("http://") && !trimmedProvidedUrl.startsWith("https://")) {
            String message = "Base URL must start with http:// or https://, got: '" + trimmedProvidedUrl + "'. Please set property: testomatio.url";
            LOGGER.warning(message);
            throw new InvalidProvidedPropertyException(message);
        }
        this.checkProvidedUrlContainsHost(trimmedProvidedUrl);
    }

    private String normalizeUrl(String url) {
        String normalizedUrl = url.trim();
        return normalizedUrl.endsWith("/") ? normalizedUrl.substring(0, normalizedUrl.length() - 1) : normalizedUrl;
    }

    private void checkProvidedUrlContainsHost(String providedUrl) {
        try {
            URI uri = URI.create(providedUrl);
            if (uri.getHost() == null || uri.getHost().isEmpty()) {
                String message = "Base URL must contain valid hostname, got: '" + providedUrl + "'. Please set property: testomatio.url";
                LOGGER.warning(message);
                throw new InvalidProvidedPropertyException(message);
            }
        }
        catch (IllegalArgumentException e) {
            String message = "Malformed base URL: '" + providedUrl + "'. Please set property: testomatio.url";
            LOGGER.severe(message);
            throw new InvalidProvidedPropertyException(message);
        }
    }

    private void validateBuiltUrl(String builtUrl) {
        try {
            new URL(builtUrl);
        }
        catch (MalformedURLException e) {
            throw new UrlBuildingException("Malformed URL result: " + builtUrl, e);
        }
    }

    private void validateTestRunId(String testRunUid) {
        if (testRunUid == null || testRunUid.trim().isEmpty()) {
            throw new UrlBuildingException("Failed to build URL. Test run id is null or empty: " + testRunUid);
        }
    }

    private String getApiKey() {
        String apiKey = this.provider.getProperty("testomatio.api.key");
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new InvalidProvidedPropertyException("API key is required. Set property: testomatio.api.key");
        }
        return apiKey.trim();
    }
}

