/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core;

import com.testomatio.reporter.client.ApiInterface;
import com.testomatio.reporter.client.ClientFactory;
import com.testomatio.reporter.client.TestomatClientFactory;
import com.testomatio.reporter.core.batch.BatchResultManager;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.model.TestResult;
import com.testomatio.reporter.propertyconfig.impl.PropertyProviderFactoryImpl;
import com.testomatio.reporter.propertyconfig.interf.PropertyProvider;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class GlobalRunManager {
    private static final GlobalRunManager INSTANCE = new GlobalRunManager();
    private static final Logger LOGGER = LoggerUtils.getLogger(GlobalRunManager.class);
    private final PropertyProvider provider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
    private final AtomicInteger activeSuites = new AtomicInteger(0);
    private final AtomicReference<String> runUid = new AtomicReference();
    private final AtomicReference<BatchResultManager> batchManager = new AtomicReference();
    private final AtomicReference<ApiInterface> apiClient = new AtomicReference();
    private final AtomicBoolean shutdownHookRegistered = new AtomicBoolean(false);
    private volatile long startTime;

    private GlobalRunManager() {
    }

    public static GlobalRunManager getInstance() {
        return INSTANCE;
    }

    public synchronized void initializeIfNeeded() {
        if (this.runUid.get() != null) {
            return;
        }
        try {
            ClientFactory clientFactory = TestomatClientFactory.getClientFactory();
            ApiInterface client = clientFactory.createClient();
            String uid = this.getCustomRunUid(client);
            this.apiClient.set(client);
            this.runUid.set(uid);
            this.batchManager.set(new BatchResultManager(client, uid));
            this.startTime = System.currentTimeMillis();
            this.registerShutdownHook();
            LOGGER.fine("Global test run initialized with UID: " + uid);
        }
        catch (Exception e) {
            LOGGER.severe("Failed to initialize test run: " + e);
        }
    }

    private void registerShutdownHook() {
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOGGER.finer("JVM is shutting down, finalizing test run...");
                this.finalizeRun();
            }, "TestRunFinalizer"));
            LOGGER.finer("Shutdown hook registered for test run finalization");
        }
    }

    public void incrementSuiteCounter() {
        this.activeSuites.incrementAndGet();
        this.initializeIfNeeded();
    }

    public void decrementSuiteCounter() {
        int remaining = this.activeSuites.decrementAndGet();
        LOGGER.finer("Active suites remaining: " + remaining);
    }

    public void reportTest(TestResult result) {
        BatchResultManager manager = this.batchManager.get();
        if (manager != null) {
            manager.addResult(result);
        }
    }

    public boolean isActive() {
        return this.runUid.get() != null;
    }

    private void finalizeRun() {
        BatchResultManager manager = this.batchManager.getAndSet(null);
        if (manager != null) {
            manager.shutdown();
        }
        String uid = this.runUid.getAndSet(null);
        ApiInterface client = this.apiClient.getAndSet(null);
        if (uid != null && client != null) {
            try {
                float duration = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
                client.finishTestRun(uid, duration);
                LOGGER.fine("Test run finished: " + uid);
            }
            catch (IOException e) {
                LOGGER.severe("Failed to finish test run" + e.getCause());
            }
        }
    }

    private String getRunTitle() {
        return PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider().getProperty("testomatio.run.title");
    }

    private String getCustomRunUid(ApiInterface client) throws IOException {
        String customUid;
        try {
            customUid = this.provider.getProperty("testomatio.run.id");
        }
        catch (Exception e) {
            customUid = client.createRun(this.getRunTitle());
        }
        return customUid;
    }
}

