/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.constructor;

import com.testomatio.reporter.core.constructor.AbstractTestResultConstructor;
import com.testomatio.reporter.core.constructor.ExceptionDetails;
import com.testomatio.reporter.core.constructor.TestResultWrapper;
import com.testomatio.reporter.model.TestResult;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JUnitTestResultConstructor
extends AbstractTestResultConstructor {
    @Override
    protected boolean hasCustomMessage(TestResultWrapper holder) {
        return holder.getMessage() != null;
    }

    @Override
    protected String getCustomMessage(TestResultWrapper holder) {
        return holder.getMessage();
    }

    @Override
    protected TestResult createWithCustomMessage(TestResultWrapper holder) {
        String stack = this.extractStackTrace(holder);
        return this.buildTestResult(holder).withMessage(holder.getMessage()).withStack(stack).build();
    }

    @Override
    protected TestResult createWithExceptionDetails(TestResultWrapper holder) {
        ExceptionDetails exceptionDetails = this.extractExceptionDetails(holder);
        return this.buildTestResult(holder).withMessage(exceptionDetails.getMessage()).withStack(exceptionDetails.getStack()).build();
    }

    @Override
    protected String getFrameworkName() {
        return "JUnit";
    }

    private ExceptionDetails extractExceptionDetails(TestResultWrapper holder) {
        return Optional.ofNullable(holder.getJunitExtensionContext()).flatMap(ExtensionContext::getExecutionException).filter(this::isReportableException).map(this::createExceptionDetails).orElse(ExceptionDetails.empty());
    }
}

