/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.extractor;

import com.testomatio.reporter.core.extractor.MetaDataExtractor;
import com.testomatio.reporter.model.TestMetadata;
import io.cucumber.plugin.event.TestCase;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;

public class CucumberMetaDataExtractor
implements MetaDataExtractor<TestCase> {
    protected static final String UNKNOWN_SUITE = "Unknown Suite";
    protected static final String UNKNOWN_FILE = "unknown";
    protected static final String UNKNOWN_TEST = "Unknown Test";
    private static final String TEST_ID_REGEX = "@T[a-z0-9]{8}";
    private static final String TITLE_PREFIX = "@title:";

    @Override
    public TestMetadata extractTestMetadata(TestCase testCase) {
        String title = this.extractTitle(testCase);
        String testId = this.extractTestId(testCase);
        String suiteTitle = this.extractSuiteTitle(testCase);
        String file = this.extractFileName(testCase);
        return new TestMetadata(title, testId, suiteTitle, file);
    }

    private String extractTitle(TestCase testCase) {
        if (testCase == null) {
            return UNKNOWN_TEST;
        }
        Optional<String> titleFromTag = this.extractFromTags(testCase).map(tag -> tag.replace("_", " "));
        return titleFromTag.orElse(this.safeGetString(testCase.getName()));
    }

    private String extractTestId(TestCase testCase) {
        if (testCase == null || testCase.getTags() == null) {
            return null;
        }
        return testCase.getTags().stream().filter(tag -> tag != null && tag.matches(TEST_ID_REGEX)).findFirst().orElse(null);
    }

    private String extractSuiteTitle(TestCase testCase) {
        return this.extractFileNameFromUri(testCase).map(this::removeFileExtension).orElse(UNKNOWN_SUITE);
    }

    private String extractFileName(TestCase testCase) {
        return this.extractFileNameFromUri(testCase).orElse("unknown.feature");
    }

    private Optional<String> extractFromTags(TestCase testCase) {
        if (testCase == null || testCase.getTags() == null) {
            return Optional.empty();
        }
        return testCase.getTags().stream().filter(tag -> tag != null && tag.toLowerCase().startsWith(TITLE_PREFIX)).map(tag -> tag.substring(TITLE_PREFIX.length())).findFirst();
    }

    private Optional<String> extractFileNameFromUri(TestCase testCase) {
        if (testCase == null || testCase.getUri() == null) {
            return Optional.empty();
        }
        return this.extractUriPath(testCase.getUri()).map(this::extractFileNameFromPath).filter(name -> !name.isEmpty());
    }

    private Optional<String> extractUriPath(URI uri) {
        String path = this.safeGet(uri::getPath);
        if (this.isValidPath(path)) {
            return Optional.of(this.cleanUriPath(path));
        }
        path = this.safeGet(uri::toString);
        if (this.isValidPath(path)) {
            return Optional.of(this.cleanUriPath(path));
        }
        path = this.safeGet(uri::getSchemeSpecificPart);
        if (this.isValidPath(path)) {
            return Optional.of(this.cleanUriPath(path));
        }
        return Optional.empty();
    }

    private String cleanUriPath(String path) {
        int colonIndex;
        if (path.contains(":") && !path.startsWith("/") && (colonIndex = path.indexOf(":")) < path.length() - 1) {
            return path.substring(colonIndex + 1);
        }
        return path;
    }

    private String extractFileNameFromPath(String path) {
        int lastSlash = path.lastIndexOf(47);
        return lastSlash != -1 ? path.substring(lastSlash + 1) : path;
    }

    private String removeFileExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        return lastDot != -1 ? fileName.substring(0, lastDot) : fileName;
    }

    private String safeGet(Supplier<String> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isValidPath(String path) {
        return path != null && !path.isEmpty();
    }

    private String safeGetString(Object obj) {
        return obj != null ? obj.toString() : UNKNOWN_TEST;
    }
}

