/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.extractor;

import com.testomatio.reporter.annotation.Title;
import com.testomatio.reporter.core.extractor.JunitMetaDataExtractor;
import com.testomatio.reporter.core.extractor.MetaDataExtractor;
import com.testomatio.reporter.core.extractor.wrapper.TestNgTestWrapper;
import com.testomatio.reporter.logger.LoggerUtils;
import com.testomatio.reporter.model.TestMetadata;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.testng.ITestResult;

public class TestNgMetaDataExtractor
implements MetaDataExtractor<TestNgTestWrapper> {
    private static final Logger LOGGER = LoggerUtils.getLogger(TestNgMetaDataExtractor.class);

    @Override
    public TestMetadata extractTestMetadata(TestNgTestWrapper wrapper) {
        if (wrapper.isRegularTest()) {
            return this.extractTestMetadataForRegularTest(wrapper.getTestResult());
        }
        return this.extractTestMetadataForDisabledTest(wrapper.getMethod(), wrapper.getTestClass());
    }

    private TestMetadata extractTestMetadataForRegularTest(ITestResult source) {
        Method method = source.getMethod().getConstructorOrMethod().getMethod();
        String title = this.getTestNgTestTitle(method, source);
        String testId = this.getTestId(method);
        String suiteTitle = source.getTestClass().getName();
        String file = suiteTitle + ".java";
        return new TestMetadata(title, testId, suiteTitle, file);
    }

    private TestMetadata extractTestMetadataForDisabledTest(Method method, Class<?> testClass) {
        String title = this.getTestTitle(method);
        String testId = this.getTestId(method);
        String suiteTitle = testClass.getSimpleName();
        String file = suiteTitle + ".java";
        LOGGER.finer(String.format("Extracted disabled test metadata - Title: %s, ID: %s, Suite: %s, File: %s", title, testId, suiteTitle, file));
        return new TestMetadata(title, testId, suiteTitle, file);
    }

    private String getTestId(Method method) {
        return JunitMetaDataExtractor.getTestId(method);
    }

    private String getTestTitle(Method method) {
        Title titleAnnotation = method.getAnnotation(Title.class);
        return titleAnnotation != null ? titleAnnotation.value() : method.getName();
    }

    private String getTestNgTestTitle(Method method, ITestResult result) {
        Title titleAnnotation = method.getAnnotation(Title.class);
        return titleAnnotation != null ? titleAnnotation.value() : result.getName();
    }
}

