/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.frameworkintegration;

import com.testomatio.reporter.core.GlobalRunManager;
import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestResultWrapper;
import com.testomatio.reporter.exception.ReportTestResultException;
import com.testomatio.reporter.model.TestMetadata;
import com.testomatio.reporter.model.TestResult;

public abstract class AbstractTestFrameworkListener {
    protected final GlobalRunManager runManager = GlobalRunManager.getInstance();
    protected final ResultConstructor resultConstructor = this.createResultConstructor();

    protected AbstractTestFrameworkListener() {
    }

    protected abstract ResultConstructor createResultConstructor();

    protected void handleSuiteStarted(String suiteName) {
        this.runManager.incrementSuiteCounter();
    }

    protected void handleSuiteFinished(String suiteName) {
        this.runManager.decrementSuiteCounter();
    }

    protected void reportTestResult(TestMetadata metadata, String status, Object frameworkSpecificData) {
        this.reportTestResult(metadata, status, null, frameworkSpecificData);
    }

    protected void reportTestResult(TestMetadata metadata, String status, String message, Object frameworkSpecificData) {
        if (!this.runManager.isActive()) {
            return;
        }
        try {
            TestResult result = this.createTestResult(metadata, status, message, frameworkSpecificData);
            this.logAndReportResult(result, status, message);
        }
        catch (Exception e) {
            String testName = metadata != null ? metadata.getTitle() : "Unknown Test";
            throw new ReportTestResultException("Failed to report test result for: " + testName, e);
        }
    }

    protected TestResult createTestResult(TestMetadata metadata, String status, String message, Object frameworkSpecificData) {
        TestResultWrapper holder = this.buildTestRunResultHolder(metadata, status, message, frameworkSpecificData);
        return this.resultConstructor.constructTestRunResult(holder);
    }

    protected TestResultWrapper buildTestRunResultHolder(TestMetadata metadata, String status, String message, Object frameworkSpecificData) {
        TestResultWrapper.Builder builder = TestResultWrapper.builder().withTestMetadata(metadata).withStatus(status);
        if (message != null) {
            builder.withMessage(message);
        }
        this.addFrameworkSpecificData(builder, frameworkSpecificData);
        return builder.build();
    }

    protected abstract void addFrameworkSpecificData(TestResultWrapper.Builder var1, Object var2);

    protected void logAndReportResult(TestResult result, String status, String message) {
        this.logTestReporting(result, status, message);
        this.runManager.reportTest(result);
    }

    protected void logTestReporting(TestResult result, String status, String message) {
        if (result.getTestId() != null) {
            Object logMessage = String.format("Reporting test with TestId: %s | Test: %s | Status: %s", result.getTestId(), result.getTitle(), status);
            if (message != null) {
                logMessage = (String)logMessage + " | Message: " + message;
            }
        } else {
            String logMessage = "Reporting test without TestId: " + result.getTitle() + " - " + status;
            if (message != null) {
                logMessage = logMessage + " | Message: " + message;
            }
        }
    }

    protected String normalizeStatus(Object frameworkStatus) {
        String statusStr;
        if (frameworkStatus == null) {
            return "failed";
        }
        switch (statusStr = frameworkStatus.toString().toUpperCase()) {
            case "PASSED": 
            case "SUCCESS": 
            case "SUCCESSFUL": {
                return "passed";
            }
            case "SKIPPED": 
            case "PENDING": 
            case "UNDEFINED": 
            case "AMBIGUOUS": 
            case "DISABLED": 
            case "ABORTED": {
                return "skipped";
            }
        }
        return "failed";
    }
}

