/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.frameworkintegration;

import com.testomatio.reporter.core.constructor.CucumberTestResultConstructor;
import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestResultWrapper;
import com.testomatio.reporter.core.extractor.CucumberMetaDataExtractor;
import com.testomatio.reporter.core.extractor.MetaDataExtractor;
import com.testomatio.reporter.core.frameworkintegration.AbstractTestFrameworkListener;
import com.testomatio.reporter.model.TestMetadata;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;

public class CucumberListener
extends AbstractTestFrameworkListener
implements Plugin,
EventListener {
    private final MetaDataExtractor<TestCase> metaDataExtractor = new CucumberMetaDataExtractor();

    public CucumberListener() {
    }

    public CucumberListener(String out) {
    }

    @Override
    protected ResultConstructor createResultConstructor() {
        return new CucumberTestResultConstructor();
    }

    @Override
    protected void addFrameworkSpecificData(TestResultWrapper.Builder builder, Object frameworkSpecificData) {
        if (frameworkSpecificData instanceof TestCaseFinished) {
            builder.withCucumberTestCaseFinished((TestCaseFinished)frameworkSpecificData);
        }
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        eventPublisher.registerHandlerFor(TestRunStarted.class, this::handleTestRunStarted);
        eventPublisher.registerHandlerFor(TestRunFinished.class, this::handleTestRunFinished);
        eventPublisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        eventPublisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
    }

    private void handleTestRunStarted(TestRunStarted event) {
        this.handleSuiteStarted("Cucumber Test Run");
    }

    private void handleTestRunFinished(TestRunFinished event) {
        this.handleSuiteFinished("Cucumber Test Run");
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        String status = this.determineTestStatus(event);
        TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(event.getTestCase());
        this.reportTestResult(metadata, status, event);
    }

    private String determineTestStatus(TestCaseFinished event) {
        if (event == null || event.getResult() == null || event.getResult().getStatus() == null) {
            return this.normalizeStatus(null);
        }
        return this.normalizeStatus(event.getResult().getStatus());
    }
}

