/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.frameworkintegration;

import com.testomatio.reporter.core.constructor.JUnitTestResultConstructor;
import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestResultWrapper;
import com.testomatio.reporter.core.extractor.JunitMetaDataExtractor;
import com.testomatio.reporter.core.extractor.MetaDataExtractor;
import com.testomatio.reporter.core.extractor.wrapper.JUnitTestWrapper;
import com.testomatio.reporter.core.frameworkintegration.AbstractTestFrameworkListener;
import com.testomatio.reporter.model.TestMetadata;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class JunitExtension
extends AbstractTestFrameworkListener
implements BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback,
TestWatcher {
    private final MetaDataExtractor<JUnitTestWrapper> junitMetaDataExtractor = new JunitMetaDataExtractor();

    @Override
    protected ResultConstructor createResultConstructor() {
        return new JUnitTestResultConstructor();
    }

    @Override
    protected void addFrameworkSpecificData(TestResultWrapper.Builder builder, Object frameworkSpecificData) {
        if (frameworkSpecificData instanceof ExtensionContext) {
            builder.withJunitExtensionContext((ExtensionContext)frameworkSpecificData);
        }
    }

    public void beforeAll(ExtensionContext context) {
        String className = context.getTestClass().map(Class::getSimpleName).orElse("Unknown");
        this.handleSuiteStarted(className);
    }

    public void afterAll(ExtensionContext context) {
        String className = context.getTestClass().map(Class::getSimpleName).orElse("Unknown");
        this.handleSuiteFinished(className);
    }

    public void beforeEach(ExtensionContext extensionContext) {
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        String reasonText = reason.orElse("Test disabled");
        this.handleTestResult(context, "skipped", reasonText);
    }

    public void testSuccessful(ExtensionContext context) {
        this.handleTestResult(context, "passed", null);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        this.handleTestResult(context, "skipped", cause.getMessage());
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        this.handleTestResult(context, "failed", cause.getMessage());
    }

    private void handleTestResult(ExtensionContext context, String status, String message) {
        Optional testMethodOptional = context.getTestMethod();
        if (testMethodOptional.isEmpty()) {
            return;
        }
        Method testMethod = (Method)testMethodOptional.get();
        JUnitTestWrapper testWrapper = new JUnitTestWrapper(testMethod, context);
        TestMetadata metadata = this.junitMetaDataExtractor.extractTestMetadata(testWrapper);
        this.reportTestResult(metadata, status, message, context);
    }
}

