/*
 * Decompiled with CFR 0.152.
 */
package com.testomatio.reporter.core.frameworkintegration;

import com.testomatio.reporter.core.constructor.ResultConstructor;
import com.testomatio.reporter.core.constructor.TestNgTestResultConstructor;
import com.testomatio.reporter.core.constructor.TestResultWrapper;
import com.testomatio.reporter.core.extractor.MetaDataExtractor;
import com.testomatio.reporter.core.extractor.TestNgMetaDataExtractor;
import com.testomatio.reporter.core.extractor.wrapper.TestNgTestWrapper;
import com.testomatio.reporter.core.frameworkintegration.AbstractTestFrameworkListener;
import com.testomatio.reporter.exception.TestClassNotFoundException;
import com.testomatio.reporter.model.TestMetadata;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class TestNgListener
extends AbstractTestFrameworkListener
implements ISuiteListener,
ITestListener,
IInvokedMethodListener {
    private static final String DISABLED_MESSAGE = "Test disabled via @Test(enabled = false)";
    private final MetaDataExtractor<TestNgTestWrapper> metaDataExtractor = new TestNgMetaDataExtractor();
    private final Set<String> processedTests = new HashSet<String>();

    @Override
    protected ResultConstructor createResultConstructor() {
        return new TestNgTestResultConstructor();
    }

    @Override
    protected void addFrameworkSpecificData(TestResultWrapper.Builder builder, Object frameworkSpecificData) {
        if (frameworkSpecificData instanceof ITestResult) {
            builder.withTestResult((ITestResult)frameworkSpecificData);
        }
    }

    public void onStart(ISuite suite) {
        this.handleSuiteStarted(suite.getName());
        this.checkAndReportDisabledTests(suite);
    }

    public void onFinish(ISuite suite) {
        this.handleSuiteFinished(suite.getName());
    }

    public void onTestSuccess(ITestResult result) {
        this.handleTestNgResult(result, "passed");
    }

    public void onTestFailure(ITestResult result) {
        this.handleTestNgResult(result, "failed");
    }

    public void onTestSkipped(ITestResult result) {
        this.handleTestNgResult(result, "skipped");
    }

    private void handleTestNgResult(ITestResult result, String status) {
        String methodKey = result.getTestClass().getName() + "." + result.getMethod().getMethodName();
        if (this.processedTests.contains(methodKey)) {
            return;
        }
        this.processedTests.add(methodKey);
        TestNgTestWrapper wrapper = TestNgTestWrapper.forRegularTest(result);
        TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(wrapper);
        this.reportTestResult(metadata, status, result);
    }

    private void checkAndReportDisabledTests(ISuite suite) {
        if (!this.runManager.isActive()) {
            return;
        }
        suite.getXmlSuite().getTests().forEach(xmlTest -> xmlTest.getXmlClasses().forEach(xmlClass -> {
            try {
                Method[] methods;
                Class<?> testClass = Class.forName(xmlClass.getName());
                for (Method method : methods = testClass.getDeclaredMethods()) {
                    String methodKey;
                    Test testAnnotation = method.getAnnotation(Test.class);
                    if (testAnnotation == null || testAnnotation.enabled() || this.processedTests.contains(methodKey = xmlClass.getName() + "." + method.getName())) continue;
                    this.processedTests.add(methodKey);
                    this.reportDisabledTest(method, testClass);
                }
            }
            catch (ClassNotFoundException e) {
                throw new TestClassNotFoundException("Failed to load test class: " + xmlClass.getName(), e);
            }
        }));
    }

    private void reportDisabledTest(Method method, Class<?> testClass) {
        TestNgTestWrapper wrapper = TestNgTestWrapper.forDisabledTest(method, testClass);
        TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(wrapper);
        this.reportTestResult(metadata, "skipped", DISABLED_MESSAGE, null);
    }
}

