/*
 * Decompiled with CFR 0.152.
 */
package io.testomat;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigLoader.class);
    private static final String PREFIX = "testomatio.";
    private static final Properties properties = new Properties();

    ConfigLoader() {
    }

    static Properties loadProperties() {
        ConfigLoader.loadFromPropertiesFile();
        ConfigLoader.loadFromEnvironment();
        logger.info("Properties loaded");
        return properties;
    }

    private static void loadFromPropertiesFile() {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testomatio.properties");){
            properties.load(is);
        }
        catch (IOException e) {
            logger.error("Warning: Could not load properties file: {}", (Object)e.getMessage());
        }
    }

    private static void loadFromEnvironment() {
        System.getenv().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("TESTOMATIO")).forEach(entry -> properties.setProperty(((String)entry.getKey()).toLowerCase().replace('_', '.'), (String)entry.getValue()));
    }

    static void loadFromProperties(Class<?> clazz, Properties properties) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            String key = PREFIX + ConfigLoader.camelToDot(field.getName());
            String value = properties.getProperty(key);
            if (value == null) continue;
            try {
                Object convertedValue = ConfigLoader.convertType(field.getType(), value);
                field.set(null, convertedValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error setting property: " + key, e);
            }
        }
    }

    private static String camelToDot(String camelCase) {
        return camelCase.replaceAll("([a-z])([A-Z])", "$1.$2").toLowerCase();
    }

    private static Object convertType(Class<?> type, String value) {
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        return value;
    }
}

