/*
 * Decompiled with CFR 0.152.
 */
package io.testomat;

import io.testomat.Testomat;
import io.testomat.TestomatConfig;
import io.testomat.api.TestomatApi;
import io.testomat.model.TTestResult;
import io.testomat.model.TTestRun;
import io.testomat.utils.SafetyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestomatReporter {
    private static final Logger logger = LoggerFactory.getLogger(TestomatReporter.class);
    private static final List<TTestResult> unpublishedResults = new ArrayList<TTestResult>();
    private static final TestomatApi api = new TestomatApi();
    private static final List<TTestResult> resultsBatch = new ArrayList<TTestResult>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void startReporter() {
        long interval = TestomatConfig.getReporterInterval();
        scheduler.scheduleAtFixedRate(TestomatReporter::sendTestResults, 1000L, interval, TimeUnit.MILLISECONDS);
    }

    public static void stopReporter() {
        logger.info("Stopping TestomatReporter");
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        TestomatReporter.sendTestResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResultToReporter(TTestResult result) {
        logger.info("Adding test result to TestomatReporter: {}", (Object)(result.getName() + " " + result.getStatus()));
        List<TTestResult> list = unpublishedResults;
        synchronized (list) {
            unpublishedResults.add(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TTestResult> pollAllUnpublishedResults() {
        ArrayList<TTestResult> copy;
        List<TTestResult> list = unpublishedResults;
        synchronized (list) {
            copy = new ArrayList<TTestResult>(unpublishedResults);
            unpublishedResults.clear();
        }
        return copy;
    }

    private static synchronized void sendTestResults() {
        resultsBatch.addAll(TestomatReporter.pollAllUnpublishedResults());
        if (resultsBatch.isEmpty()) {
            return;
        }
        SafetyUtils.invokeSafety("TestomatReporter:sendTestResults", () -> {
            resultsBatch.addAll(TestomatReporter.pollAllUnpublishedResults());
            if (resultsBatch.isEmpty()) {
                return;
            }
            TTestRun testRun = new TTestRun();
            testRun.setId(Testomat.getTestRun().getId());
            testRun.setTestResults(resultsBatch);
            api.addTestResultsToTestRun(testRun);
            resultsBatch.clear();
        });
    }
}

