/*
 * Decompiled with CFR 0.152.
 */
package io.testomat;

import io.testomat.Testomat;
import io.testomat.model.TStepResult;
import io.testomat.utils.StringFormatterUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class TestomatStepsAspect {
    private static final Logger logger = LoggerFactory.getLogger(TestomatStepsAspect.class);

    @Pointcut(value="@annotation(io.testomat.annotation.Step) || @annotation(io.qameta.allure.Step)")
    public void stepMethod() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && stepMethod()")
    public void beforeStep(JoinPoint joinPoint) {
        logger.info("Step started: " + joinPoint.getSignature().getName());
        TStepResult parentStep = Testomat.getCurrentTestResult().getCurrentStep();
        TStepResult step = new TStepResult(StringFormatterUtils.capitalizeAndSplit(joinPoint.getSignature().getName()), parentStep);
        step.setParameters(this.parseParameters(joinPoint));
        step.setArguments(Arrays.asList(joinPoint.getArgs()));
        step.startTime();
        Testomat.getCurrentTestResult().setCurrentStep(step);
        if (parentStep == null) {
            Testomat.getCurrentTestResult().getSteps().add(step);
        } else {
            parentStep.addInnerStep(step);
        }
    }

    @AfterReturning(value="anyMethod() && stepMethod()")
    public void afterStep(JoinPoint joinPoint) {
        TStepResult tStepResult = Testomat.getCurrentTestResult().getCurrentStep();
        tStepResult.setStatus("passed");
        tStepResult.stopTime();
        Testomat.getCurrentTestResult().setCurrentStep(tStepResult.getParent());
    }

    @AfterThrowing(pointcut="anyMethod() && stepMethod()", throwing="ex")
    public void afterStepFailure(JoinPoint joinPoint, Throwable ex) {
        TStepResult tStepResult = Testomat.getCurrentTestResult().getCurrentStep();
        tStepResult.setStatus("failed");
        tStepResult.stopTime();
        tStepResult.setError(ex.getMessage());
        Testomat.getCurrentTestResult().setCurrentStep(tStepResult.getParent());
    }

    private Map<String, Object> parseParameters(JoinPoint joinPoint) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        String[] parameterNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            parameters.put(parameterNames[i], args[i]);
        }
        return parameters;
    }
}

