/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import io.testomat.TestomatConfig;
import io.testomat.api.TestRun;
import io.testomat.api.TestRunResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

class RestClient {
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final String apiKey = TestomatConfig.getApiKey();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RestClient() {
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    TestRunResponse createTestRun(TestRun testRun) {
        HttpRequest request = this.createRequest("reporter").POST(HttpRequest.BodyPublishers.ofString(this.writeValueAsString(testRun))).build();
        System.out.println(request.uri());
        HttpResponse<String> response = this.sendRequest(request);
        System.out.println(response.body());
        return this.readJsonAsObject(response.body(), TestRunResponse.class);
    }

    TestRunResponse updateTestRun(TestRun testRun) {
        HttpRequest request = this.createRequest("reporter/" + testRun.id).PUT(HttpRequest.BodyPublishers.ofString(this.writeValueAsString(testRun))).build();
        HttpResponse<String> response = this.sendRequest(request);
        return this.readJsonAsObject(response.body(), TestRunResponse.class);
    }

    String addTestResultsToTestRun(TestRun testRun) {
        HttpRequest request = this.createRequest("reporter/" + testRun.id + "/testrun").POST(HttpRequest.BodyPublishers.ofString(this.writeValueAsString(testRun))).build();
        HttpResponse<String> response = this.sendRequest(request);
        return response.body();
    }

    private HttpRequest.Builder createRequest(String path) {
        return HttpRequest.newBuilder().header("Content-Type", "application/json").uri(URI.create(TestomatConfig.getApiUrl() + path + "?api_key=" + this.apiKey));
    }

    private HttpResponse<String> sendRequest(HttpRequest request) {
        try {
            return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String writeValueAsString(Object value) {
        try {
            String json = this.objectMapper.writeValueAsString(value);
            System.out.println(json);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T readJsonAsObject(String json, Class<T> type) {
        try {
            System.out.println(json);
            return (T)this.objectMapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

