/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.api;

import com.fasterxml.jackson.annotation.JsonValue;
import io.testomat.api.TestResult;
import io.testomat.model.TTestRun;
import java.util.List;

class TestRun {
    public String id;
    public String title;
    public List<String> tags;
    public String env;
    public String groupTitle;
    public Boolean parallel;
    public StatusEvent statusEvent;
    public List<TestResult> tests;
    public Boolean createTests;
    public Integer testsCount;
    public String ciBuildUrl;
    public List<Object> labels;

    TestRun() {
    }

    public static TestRun parse(TTestRun run) {
        TestRun testRun = new TestRun();
        testRun.id = run.getId();
        testRun.title = run.getName();
        testRun.env = run.getEnv();
        testRun.groupTitle = run.getGroupTitle();
        testRun.tests = run.getTestResults().stream().map(TestResult::parse).toList();
        testRun.tags = run.getTags();
        testRun.testsCount = run.getTestsCount();
        testRun.ciBuildUrl = run.getCiBuildUrl();
        return testRun;
    }

    public static class Builder {
        private final TestRun instance = new TestRun();

        public Builder id(String id) {
            this.instance.id = id;
            return this;
        }

        public Builder title(String title) {
            this.instance.title = title;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.instance.tags = tags;
            return this;
        }

        public Builder env(String env) {
            this.instance.env = env;
            return this;
        }

        public Builder groupTitle(String groupTitle) {
            this.instance.groupTitle = groupTitle;
            return this;
        }

        public Builder parallel(Boolean parallel) {
            this.instance.parallel = parallel;
            return this;
        }

        public Builder statusEvent(StatusEvent statusEvent) {
            this.instance.statusEvent = statusEvent;
            return this;
        }

        public Builder tests(List<TestResult> tests) {
            this.instance.tests = tests;
            return this;
        }

        public Builder createTests(Boolean createTests) {
            this.instance.createTests = createTests;
            return this;
        }

        public Builder testsCount(Integer testsCount) {
            this.instance.testsCount = testsCount;
            return this;
        }

        public TestRun build() {
            return this.instance;
        }
    }

    public static enum StatusEvent {
        PASS,
        FAIL,
        FINISH,
        PASS_PARALLEL,
        FAIL_PARALLEL,
        FINISH_PARALLEL;


        @JsonValue
        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

