/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.api;

import io.testomat.model.TStepResult;
import java.util.List;
import java.util.Map;

class TestStep {
    public String category;
    public String title;
    public Long duration;
    public Map<String, Object> error;
    public List<TestStep> steps;
    public Map<String, Object> options;

    TestStep() {
    }

    public static TestStep parse(TStepResult step) {
        return new Builder().title(step.getTitle() + (String)(step.getParameters().isEmpty() ? "" : " " + String.valueOf(step.getParameters()))).duration(step.getDuration()).steps(step.getSteps().stream().map(TestStep::parse).toList()).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private final TestStep instance;

        public Builder() {
            this.instance = new TestStep();
        }

        public Builder(TestStep model) {
            this.instance = model;
        }

        public Builder category(String category) {
            this.instance.category = category;
            return this;
        }

        public Builder title(String title) {
            this.instance.title = title;
            return this;
        }

        public Builder duration(Long duration) {
            this.instance.duration = duration;
            return this;
        }

        public Builder error(Map<String, Object> error) {
            this.instance.error = error;
            return this;
        }

        public Builder steps(List<TestStep> steps) {
            this.instance.steps = steps;
            return this;
        }

        public Builder options(Map<String, Object> options) {
            this.instance.options = options;
            return this;
        }

        public TestStep build() {
            return this.instance;
        }
    }
}

