/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.model;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TStepResult {
    private TStepResult parent;
    private List<TStepResult> steps;
    private String title;
    private String status;
    private String error;
    private LocalDateTime startedAt;
    private LocalDateTime finishedAt;
    private Map<String, Object> attributes;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private List<Object> arguments;

    public TStepResult(String methodName, TStepResult parentStep) {
        this.title = methodName;
        this.parent = parentStep;
        this.steps = new ArrayList<TStepResult>();
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public List<TStepResult> getSteps() {
        return this.steps;
    }

    public void startTime() {
        this.startedAt = LocalDateTime.now();
    }

    public void stopTime() {
        this.finishedAt = LocalDateTime.now();
    }

    public String getTitle() {
        return this.title;
    }

    public Long getDuration() {
        if (this.startedAt == null || this.finishedAt == null) {
            return 0L;
        }
        return Duration.between(this.startedAt, this.finishedAt).toMillis();
    }

    public void addInnerStep(TStepResult step) {
        this.steps.add(step);
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setArguments(List<Object> arguments) {
        this.arguments = arguments;
    }

    public TStepResult getParent() {
        return this.parent;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "Step " + this.title;
    }
}

