/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.model;

import io.testomat.model.TStepResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TTestResult {
    private String testId;
    public String rid;
    private String name;
    private String testFullName;
    private LocalDateTime startedAt;
    private LocalDateTime finishedAt;
    private Long duration;
    private String status;
    private List<TStepResult> steps = new ArrayList<TStepResult>();
    private String message;
    private String stackTrace;
    private Map<String, Object> parameters;
    private Map<String, Object> meta;
    private List<String> artifacts;
    private String code;
    private TStepResult currentStep;

    public TStepResult getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(TStepResult currentStep) {
        this.currentStep = currentStep;
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getRid() {
        if (this.rid == null) {
            this.rid = this.generateRid();
        }
        return this.rid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTestFullName() {
        return this.testFullName;
    }

    public void setTestFullName(String testFullName) {
        this.testFullName = testFullName;
    }

    public LocalDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(LocalDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public LocalDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<TStepResult> getSteps() {
        return this.steps;
    }

    public void setSteps(List<TStepResult> steps) {
        this.steps = steps;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public List<String> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<String> artifacts) {
        this.artifacts = artifacts;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setFinishedAt(LocalDateTime now) {
        this.finishedAt = now;
        this.duration = this.startedAt != null ? Duration.between(this.startedAt, this.finishedAt).toMillis() : 0L;
    }

    public void addParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        this.parameters.put(key, value);
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void addMeta(String key, Object value) {
        if (this.meta == null) {
            this.meta = new LinkedHashMap<String, Object>();
        }
        this.meta.put(key, value);
    }

    public void addArtifact(String artifact) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<String>();
        }
        this.artifacts.add(artifact);
    }

    private String generateRid() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.testFullName);
        if (this.parameters != null) {
            this.parameters.forEach((key, value) -> sb.append((String)key).append(value));
        }
        byte[] encodedBytes = Base64.getEncoder().encode(sb.toString().getBytes(StandardCharsets.UTF_8));
        return new String(encodedBytes, StandardCharsets.UTF_8);
    }

    public static class Builder {
        private TTestResult instance = new TTestResult();

        public Builder setTestId(String testId) {
            this.instance.testId = testId;
            return this;
        }

        public Builder setName(String name) {
            this.instance.name = name;
            return this;
        }

        public Builder setTestFullName(String testFullName) {
            this.instance.testFullName = testFullName;
            return this;
        }

        public Builder setStartedAt(LocalDateTime startedAt) {
            this.instance.startedAt = startedAt;
            return this;
        }

        public Builder setFinishedAt(LocalDateTime finishedAt) {
            this.instance.finishedAt = finishedAt;
            return this;
        }

        public Builder setDuration(Long duration) {
            this.instance.duration = duration;
            return this;
        }

        public Builder setStatus(String status) {
            this.instance.status = status;
            return this;
        }

        public Builder setSteps(List<TStepResult> steps) {
            this.instance.steps = steps;
            return this;
        }

        public Builder setMessage(String message) {
            this.instance.message = message;
            return this;
        }

        public Builder setStackTrace(String stackTrace) {
            this.instance.stackTrace = stackTrace;
            return this;
        }

        public Builder setParameters(Map<String, Object> parameters) {
            this.instance.parameters = parameters;
            return this;
        }

        public Builder setArtifacts(List<String> artifacts) {
            this.instance.artifacts = artifacts;
            return this;
        }

        public Builder setCode(String code) {
            this.instance.code = code;
            return this;
        }

        public TTestResult build() {
            return this.instance;
        }
    }
}

