/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.model;

import io.testomat.TestomatConfig;
import io.testomat.model.TTestResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class TTestRun {
    private String id;
    private String name;
    private String groupTitle;
    private String env;
    private LocalDateTime startedAt;
    private LocalDateTime finishedAt;
    private List<TTestResult> testResults = new ArrayList<TTestResult>();
    private List<String> tags;
    private Integer testsCount;
    private String ciBuildUrl;

    public void setId(String id) {
        this.id = id;
    }

    public LocalDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(LocalDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public LocalDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(LocalDateTime finishedAt) {
        this.finishedAt = finishedAt;
    }

    public void setTestResults(List<TTestResult> testResults) {
        this.testResults = testResults;
    }

    public String getCiBuildUrl() {
        return this.ciBuildUrl;
    }

    public void setCiBuildUrl(String ciBuildUrl) {
        this.ciBuildUrl = ciBuildUrl;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getGroupTitle() {
        return this.groupTitle;
    }

    public void setGroupTitle(String groupTitle) {
        this.groupTitle = groupTitle;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setTestsCount(Integer testsCount) {
        this.testsCount = testsCount;
    }

    public Integer getTestsCount() {
        return this.testsCount;
    }

    public boolean isFinished() {
        return this.finishedAt != null;
    }

    public String getRunUrl() {
        return String.format("%s/projects/%s/runs/%s", TestomatConfig.getHost(), TestomatConfig.getProject(), this.id);
    }

    public String getReportUrl() {
        return this.getRunUrl() + "/report";
    }

    public List<TTestResult> getTestResults() {
        return this.testResults;
    }

    public static class Builder {
        private TTestRun instance = new TTestRun();

        public Builder setId(String id) {
            this.instance.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.instance.name = name;
            return this;
        }

        public Builder setEnv(String env) {
            this.instance.env = env;
            return this;
        }

        public Builder setStartedAt(LocalDateTime startedAt) {
            this.instance.startedAt = startedAt;
            return this;
        }

        public Builder setFinishedAt(LocalDateTime finishedAt) {
            this.instance.finishedAt = finishedAt;
            return this;
        }

        public Builder setTestResults(List<TTestResult> testResults) {
            this.instance.testResults = testResults;
            return this;
        }

        public Builder setTags(List<String> tags) {
            this.instance.tags = tags;
            return this;
        }

        public TTestRun build() {
            return this.instance;
        }
    }
}

