/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.testng;

import io.testomat.ITestRunListener;
import io.testomat.Testomat;
import io.testomat.TestomatReporter;
import io.testomat.api.TestRunResponse;
import io.testomat.api.TestomatApi;
import io.testomat.utils.SafetyUtils;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class TestomatSuiteTestNGListener
implements ISuiteListener {
    private static final Logger logger = LoggerFactory.getLogger(TestomatSuiteTestNGListener.class);
    private final ServiceLoader<ITestRunListener> loader = ServiceLoader.load(ITestRunListener.class);
    private final TestomatApi api = new TestomatApi();

    public void onStart(ISuite suite) {
        SafetyUtils.invokeSafety("TestomatSuiteTestNGListener:onStart", () -> {
            this.loader.forEach(listener -> listener.beforeCreate(Testomat.getTestRun()));
            if (!Testomat.isEnabled()) {
                return;
            }
            TestomatReporter.startReporter();
            this.createTestRun(suite);
            this.loader.forEach(listener -> listener.afterCreate(Testomat.getTestRun()));
        });
    }

    public void onFinish(ISuite suite) {
        if (!Testomat.isEnabled()) {
            return;
        }
        SafetyUtils.invokeSafety("TestomatSuiteTestNGListener:onFinish", () -> {
            this.loader.forEach(listener -> listener.beforeFinish(Testomat.getTestRun()));
            TestomatReporter.stopReporter();
            this.api.finishTestRun(Testomat.getTestRun().getId());
            logger.info("Finished TestRun: {}", (Object)Testomat.getTestRun().getReportUrl());
            this.loader.forEach(listener -> listener.afterFinish(Testomat.getTestRun()));
        });
    }

    public void createTestRun(ISuite suite) {
        if (Testomat.getTestRun().getName() == null) {
            Testomat.getTestRun().setName(suite.getName());
        }
        Testomat.getTestRun().setTestsCount(suite.getAllMethods().size());
        TestRunResponse response = this.api.createTestRun(Testomat.getTestRun());
        Testomat.getTestRun().setId(response.getUid());
        logger.info("Created TestRun: {}", (Object)response.getUrl());
    }
}

