/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.utils;

public class ANSIFormatterUtils {
    private static final String CODE = "```";
    private static final String RESET = "\u001b[0m";
    private static final String BOLD = "\u001b[1m";
    private static final String ITALIC = "\u001b[3m";
    private static final String UNDERLINE = "\u001b[4m";
    private static final String REVERSED = "\u001b[7m";
    private static final String BLACK_TEXT = "\u001b[30m";
    private static final String RED_TEXT = "\u001b[31m";
    private static final String GREEN_TEXT = "\u001b[32m";
    private static final String YELLOW_TEXT = "\u001b[33m";
    private static final String BLUE_TEXT = "\u001b[34m";
    private static final String MAGENTA_TEXT = "\u001b[35m";
    private static final String CYAN_TEXT = "\u001b[36m";
    private static final String WHITE_TEXT = "\u001b[37m";
    private static final String BLACK_BACKGROUND = "\u001b[40m";
    private static final String RED_BACKGROUND = "\u001b[41m";
    private static final String GREEN_BACKGROUND = "\u001b[42m";
    private static final String YELLOW_BACKGROUND = "\u001b[43m";
    private static final String BLUE_BACKGROUND = "\u001b[44m";
    private static final String MAGENTA_BACKGROUND = "\u001b[45m";
    private static final String CYAN_BACKGROUND = "\u001b[46m";
    private static final String WHITE_BACKGROUND = "\u001b[47m";

    private ANSIFormatterUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String bold(String text) {
        return BOLD + text + RESET;
    }

    public static String italic(String text) {
        return ITALIC + text + RESET;
    }

    public static String underline(String text) {
        return UNDERLINE + text + RESET;
    }

    public static String reversed(String text) {
        return REVERSED + text + RESET;
    }

    public static String color(String text, String colorCode) {
        return colorCode + text + RESET;
    }

    public static String backgroundColor(String text, String colorCode) {
        return colorCode + text + RESET;
    }

    public static String boldAndColor(String text, String colorCode) {
        return BOLD + colorCode + text + RESET;
    }

    public static String boldColorAndBackground(String text, String textColor, String backgroundColor) {
        return BOLD + textColor + backgroundColor + text + RESET;
    }

    public static String code(String text) {
        if (text == null) {
            return null;
        }
        return CODE + text + CODE;
    }
}

