/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.testng.Reporter;

public class ExceptionSourceCodePointer {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_RED_BACKGROUND = "\u001b[41m";
    private static final String PATH = "src/test/java/";

    private static List<String> getLines(String filePath) {
        try {
            return Files.readAllLines(Paths.get(PATH + filePath, new String[0]), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getSourceCodeFragment(String filePath, int lineBegin, int lineEnd, int linePointer, boolean isColorsEnabled) {
        List<String> lines = ExceptionSourceCodePointer.getLines(filePath);
        StringBuilder sb = new StringBuilder();
        for (int i = lineBegin - 1; i < lineEnd; ++i) {
            sb.append("\n");
            if (i == linePointer - 1) {
                sb.append(ExceptionSourceCodePointer.getMarkedLine(isColorsEnabled, lines.get(i), i));
                continue;
            }
            sb.append("   ").append(i).append(" |").append(lines.get(i));
        }
        return sb.toString();
    }

    private static String getMarkedLine(boolean isColorsEnabled, String line, int lineNumber) {
        StringBuilder sb = new StringBuilder();
        if (isColorsEnabled) {
            sb.append(ANSI_RED_BACKGROUND).append(">>>").append(lineNumber).append(ANSI_RESET).append(" |").append(ANSI_RED).append(line).append(ANSI_RESET);
        } else {
            sb.append(">> ").append(lineNumber).append(" |").append(line);
        }
        return sb.toString();
    }

    public static String parseExceptionSourceCodeFragment(StackTraceElement[] stackTrace, boolean isColorsEnabled) {
        try {
            String methodName = Reporter.getCurrentTestResult().getMethod().getMethodName();
            StackTraceElement stackTraceElement = Arrays.stream(stackTrace).filter(e -> e.getMethodName().equals(methodName)).findFirst().orElseThrow();
            String filePath = stackTraceElement.getClassName().replace(".", "/") + ".java";
            int pointerLine = stackTraceElement.getLineNumber();
            return "Class: " + filePath + " Method: " + methodName + ExceptionSourceCodePointer.getSourceCodeFragment(filePath, pointerLine - 5, pointerLine + 1, pointerLine, isColorsEnabled);
        }
        catch (Exception e2) {
            return "ExceptionSourcePointer: Error occurred while parsing exception source code fragment";
        }
    }
}

