/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.err;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.thedocs.soyuz.err.Err;
import io.thedocs.soyuz.err.Errors;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@JsonSerialize(using=Serializer.class)
public class AnswerOrErrors<T> {
    private T answer;
    private Errors errors;

    private AnswerOrErrors(T answer) {
        this.answer = answer;
    }

    private AnswerOrErrors(Errors errors) {
        this.errors = errors;
    }

    private AnswerOrErrors(T answer, Errors errors) {
        this.answer = answer;
        this.errors = errors;
    }

    public AnswerOrErrors<T> ifOk(Consumer<AnswerOrErrors<T>> consumer) {
        if (consumer != null && this.isOk()) {
            consumer.accept(this);
        }
        return this;
    }

    public AnswerOrErrors<T> ifOk(Runnable runnable) {
        if (runnable != null && this.isOk()) {
            runnable.run();
        }
        return this;
    }

    public AnswerOrErrors<T> ifOk(Supplier<AnswerOrErrors<T>> supplier) {
        if (supplier != null && this.isOk()) {
            return supplier.get();
        }
        return this;
    }

    public AnswerOrErrors<T> ifOk(Function<AnswerOrErrors<T>, AnswerOrErrors<T>> func) {
        if (func != null && this.isOk()) {
            return func.apply(this);
        }
        return this;
    }

    public AnswerOrErrors<T> ifHasErrors(Consumer<AnswerOrErrors<T>> consumer) {
        if (consumer != null && this.hasErrors()) {
            consumer.accept(this);
        }
        return this;
    }

    public AnswerOrErrors<T> ifHasErrors(Runnable runnable) {
        if (runnable != null && this.hasErrors()) {
            runnable.run();
        }
        return this;
    }

    public AnswerOrErrors<T> ifHasErrors(Supplier<AnswerOrErrors<T>> supplier) {
        if (supplier != null && this.hasErrors()) {
            return supplier.get();
        }
        return this;
    }

    public AnswerOrErrors<T> ifHasErrors(Function<AnswerOrErrors<T>, AnswerOrErrors<T>> func) {
        if (func != null && this.hasErrors()) {
            return func.apply(this);
        }
        return this;
    }

    public boolean isOk() {
        return !this.hasErrors();
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.hasErrors();
    }

    @Nullable
    public T getAnswer() {
        return this.answer;
    }

    @Nullable
    public Errors getErrors() {
        return this.errors;
    }

    public static <T> AnswerOrErrors<T> ok() {
        return new AnswerOrErrors<Object>(null);
    }

    public static <T> AnswerOrErrors<T> ok(T object) {
        return new AnswerOrErrors<T>(object);
    }

    public static <T> AnswerOrErrors<T> failure(T object, Errors errors) {
        return new AnswerOrErrors<T>(object, errors);
    }

    public static <T> AnswerOrErrors<T> failure(T object, Err ... errors) {
        if (object instanceof Err) {
            return new AnswerOrErrors<Object>(null, Errors.reject((Err)object));
        }
        return new AnswerOrErrors<T>(object, Errors.reject(errors));
    }

    public static <T> AnswerOrErrors<T> failure(Errors errors) {
        return new AnswerOrErrors<T>(errors);
    }

    public static <T> AnswerOrErrors<T> failure(Err ... errors) {
        return new AnswerOrErrors<T>(Errors.reject(errors));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerOrErrors)) {
            return false;
        }
        AnswerOrErrors other = (AnswerOrErrors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$answer = this.getAnswer();
        T other$answer = other.getAnswer();
        if (this$answer == null ? other$answer != null : !this$answer.equals(other$answer)) {
            return false;
        }
        Errors this$errors = this.getErrors();
        Errors other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnswerOrErrors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : $answer.hashCode());
        Errors $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public String toString() {
        return "AnswerOrErrors(answer=" + this.getAnswer() + ", errors=" + this.getErrors() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Deserializer<T> {
        private T answer;
        private List<Err> errors;

        public AnswerOrErrors<T> toAnswerOrErrors() {
            if (this.errors != null && this.errors.size() > 0) {
                return new AnswerOrErrors(this.answer, Errors.reject(this.errors));
            }
            return AnswerOrErrors.ok(this.answer);
        }

        public T getAnswer() {
            return this.answer;
        }

        public List<Err> getErrors() {
            return this.errors;
        }
    }

    protected static class Serializer
    extends JsonSerializer<AnswerOrErrors> {
        protected Serializer() {
        }

        public void serialize(AnswerOrErrors value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            HashMap<String, Object> a = new HashMap<String, Object>();
            a.put("answer", value.getAnswer());
            a.put("ok", value.isOk());
            if (!value.hasErrors()) {
                a.put("errors", null);
            } else {
                a.put("errors", value.errors.get());
            }
            jgen.writeObject(a);
        }
    }
}

